﻿---
title: SQL overview
description: Elasticsearch SQL aims to provide a powerful yet lightweight SQL interface to Elasticsearch. Elasticsearch SQL is a feature that allows SQL-like queries...
url: https://www.elastic.co/docs/explore-analyze/query-filter/languages/sql
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# SQL overview
Elasticsearch SQL aims to provide a powerful yet lightweight SQL interface to Elasticsearch.

## What's SQL in Elasticsearch?

Elasticsearch SQL is a feature that allows SQL-like queries to be executed in real-time against Elasticsearch. Whether using the REST interface, command-line or JDBC, any client can use SQL to search and aggregate data *natively* inside Elasticsearch. One can think of Elasticsearch SQL as a *translator*, one that understands both SQL and Elasticsearch and makes it easy to read and process data in real-time, at scale by leveraging Elasticsearch capabilities.

## Why Elasticsearch SQL ?

<definitions>
  <definition term="Native integration">
    Elasticsearch SQL is built from the ground up for Elasticsearch. Each and every query is efficiently executed against the relevant nodes according to the underlying storage.
  </definition>
  <definition term="No external parts">
    No need for additional hardware, processes, runtimes or libraries to query Elasticsearch; Elasticsearch SQL eliminates extra moving parts by running *inside* the Elasticsearch cluster.
  </definition>
  <definition term="Lightweight and efficient">
    Elasticsearch SQL does not abstract Elasticsearch and its search capabilities - on the contrary, it embraces and exposes SQL to allow proper full-text search, in real-time, in the same declarative, succinct fashion.
  </definition>
</definitions>


## Reference documentation

<note>
  This overview page is in the Explore & Analyze section. All of the Elasticsearch SQL documentation lives in the **Reference** section.
</note>

<definitions>
  <definition term="Overview">
    Overview of Elasticsearch SQL and its features.
  </definition>
  <definition term="Getting Started">
    Start using SQL right away in Elasticsearch.
  </definition>
  <definition term="Concepts and Terminology">
    Language conventions across SQL and Elasticsearch.
  </definition>
  <definition term="Security">
    Secure Elasticsearch SQL and Elasticsearch.
  </definition>
  <definition term="REST API">
    Execute SQL in JSON format over REST.
  </definition>
  <definition term="Translate API">
    Translate SQL in JSON format to Elasticsearch native query.
  </definition>
  <definition term="CLI">
    Command-line application for executing SQL against Elasticsearch.
  </definition>
  <definition term="JDBC">
    JDBC driver for Elasticsearch.
  </definition>
  <definition term="ODBC">
    ODBC driver for Elasticsearch.
  </definition>
  <definition term="Client Applications">
    Setup various SQL/BI tools with Elasticsearch SQL.
  </definition>
  <definition term="SQL Language">
    Overview of the Elasticsearch SQL language, such as supported data types, commands and syntax.
  </definition>
  <definition term="Functions and Operators">
    List of functions and operators supported.
  </definition>
  <definition term="Limitations">
    Elasticsearch SQL current limitations.
  </definition>
</definitions>