﻿---
title: Lucene query syntax
description: Lucene query syntax is available to Kibana users who opt out of the Kibana Query Language. Full documentation for this syntax is available as part of...
url: https://www.elastic.co/docs/explore-analyze/query-filter/languages/lucene-query-syntax
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Lucene query syntax
Lucene query syntax is available to Kibana users who opt out of the [Kibana Query Language](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql). Full documentation for this syntax is available as part of Elasticsearch [query string syntax](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-query-string-query#query-string-syntax).
The main reason to use the Lucene query syntax in Kibana is for advanced Lucene features, such as regular expressions or fuzzy term matching. However, Lucene syntax is not able to search nested objects or scripted fields.
To use the Lucene syntax, open the **Saved query** menu, and then select **Language: KQL** > **Lucene**.
![Click the circle icon for the saved query menu](https://www.elastic.co/docs/explore-analyze/images/kibana-lucene.png)
To perform a free text search, simply enter a text string. For example, if you’re searching web server logs, you could enter `safari` to search all fields:
```yaml
safari
```

To search for a value in a specific field, prefix the value with the name of the field:
```yaml
status:200
```

To search for a range of values, use the bracketed range syntax, `[START_VALUE TO END_VALUE]`. For example, to find entries that have 4xx status codes, you could enter `status:[400 TO 499]`.
```yaml
status:[400 TO 499]
```

For an open range, use a wildcard:
```yaml
status:[400 TO *]
```

To specify more complex search criteria, use the boolean operators `AND`, `OR`, and `NOT`. For example, to find entries that have 4xx status codes and have an extension of `php` or `html`:
```yaml
status:[400 TO 499] AND (extension:php OR extension:html)
```