﻿---
title: Use ES|QL in the Kibana UI
description: You can use Elasticsearch query language (ES|QL) in Kibana to query and aggregate your data, create visualizations, and set up alerts. This page guides...
url: https://www.elastic.co/docs/explore-analyze/query-filter/languages/esql-kibana
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Use ES|QL in the Kibana UI
You can use [Elasticsearch query language (ES|QL)](https://www.elastic.co/docs/reference/query-languages/esql/esql-syntax-reference) in Kibana to query and aggregate your data, create visualizations, and set up alerts.
This page guides you through the basics of working with ES|QL in the Kibana UI.
ES|QL is tightly integrated with Elastic solutions:
- **Observability**
  - Query metrics, logs, and traces simultaneously
- Define fields dynamically, enrich data with lookups, and process queries in parallel
- Integrate with machine learning and AiOps for improved detection accuracy using aggregated thresholds
- **Security**
  - Enrich investigation data with lookups and dynamic field creation
- Perform IP geolocation, threat intelligence, and cloud provider identification from a single query
- Use aggregated values in detection rules for more accurate alerts
- Find more details and examples in [ES|QL for Elastic Security use cases](https://www.elastic.co/docs/solutions/security/esql-for-security)

<tip>
  Find the complete list of supported commands, functions, and operators in the [ES|QL reference](https://www.elastic.co/docs/reference/query-languages/esql/esql-syntax-reference).
</tip>


## Load sample data

To run the queries in this guide in the Kibana UI, you must load the "Sample web logs" sample data set. Follow these steps:
1. Select **Sample Data** from the **Integrations** page in Kibana
2. Select **Other sample data sets**
3. Click **Add data** on the **Sample web logs** card


## Enable or disable ES|QL

ES|QL is enabled by default in Kibana. It can be disabled using the `enableESQL` setting from the [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings).
This will hide the ES|QL user interface from various applications. However, users will be able to access existing ES|QL artifacts like saved searches and visualizations.

## The ES|QL editor

To get started with ES|QL, go to **Discover**. Next, select `code` **ES|QL** or **Try ES|QL** from the application menu.

### The query bar

After switching to ES|QL mode, the query bar shows your previous KQL or Lucene query converted into ES|QL. If the query was empty, it shows a sample query. For example:
```esql
FROM kibana_sample_data_logs | LIMIT 10
```

Every query starts with a [source command](https://www.elastic.co/docs/reference/query-languages/esql/commands/source-commands). In this query, the source command is [`FROM`](https://www.elastic.co/docs/reference/query-languages/esql/commands/from). `FROM` retrieves data from data streams, indices, or aliases. In this example, the data is retrieved from `kibana_sample_data_logs`.
A source command can be followed by one or more [processing commands](https://www.elastic.co/docs/reference/query-languages/esql/commands/processing-commands). In this query, the processing command is [`LIMIT`](https://www.elastic.co/docs/reference/query-languages/esql/commands/limit). `LIMIT` limits the number of rows that are retrieved.
<tip>
  Click the **ESQL help** button to open the in-product reference documentation for all commands and functions or to get recommended queries that will help you get started.
</tip>

Discover suggests possible commands and functions to autocomplete your query:
![esql kibana auto complete](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-auto-complete.png)

<note>
  ES|QL keywords are case-insensitive. The following query is identical to the previous one:
  ```esql
  FROM kibana_sample_data_logs | LIMIT 10
  ```
</note>


### Convert free-text searches into ES|QL

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

You can use the **Quick search** functionality of the ES|QL editor to translate a free-text search into a functioning ES|QL query with a `WHERE KQL()` clause. This can be useful if you're getting started with ES|QL and are familiar with [KQL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql).
1. Select **Quick search** in the editor's footer, or press <kbd>Cmd</kbd> + <kbd>k</kbd> (Mac) or <kbd>Ctrl</kbd> + <kbd>k</kbd> (Windows/Linux) to open the **Quick search** bar.
2. Select the data sources to search.
3. Type the text you want to search for.
4. Submit your search by pressing **Enter**. A new ES|QL query is generated and overwrites the current query. It includes a `FROM` command based on the data sources you selected (or `TS` if the data source is a time series data stream), and a `WHERE KQL()` command that contains the text you typed in the search bar. Any queries that you have previously run are saved in the query history if you need to restore them.
5. Refine your query with any other ES|QL command or function that you need. The **Quick search** bar closes automatically when you start typing in the editor or click outside of it.

![Quick search bar in the ES|QL editor](https://images.contentstack.io/v3/assets/bltefdd0b53724fa2ce/bltc8165d27051bdac3/6966744e818dc30008b336f8/esql-quick-search.gif)

### Make your query readable

For readability, you can put each processing command on a new line and add indentation. The following query is identical to the previous one:
```esql
FROM kibana_sample_data_logs
  | LIMIT 10
```

You can do that automatically using the `pipeBreaks` **Prettify query** button from the query editor’s footer.
![Automatic line breaks and indentation for ES|QL queries](https://www.elastic.co/docs/explore-analyze/images/esql-line-breakdown.gif)

You can adjust the editor’s height by dragging its bottom border to your liking.

### Warnings

A query may result in warnings, for example when querying an unsupported field type. When that happens, a warning symbol is shown in the query bar. To see the detailed warning, expand the query bar, and click **warnings**.

### Query history

You can reuse your recent ES|QL queries in the query bar. In the query bar, select **Show recent queries**.
You can then:
- scroll through your most recent queries
- <applies-to>Elastic Stack: Generally available since 9.2</applies-to> search for specific queries of your history

![esql discover query history](https://www.elastic.co/docs/explore-analyze/images/esql-history.gif)

<note>
  The maximum number of queries in the history depends on the version you're using:
  - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.2</applies-to> The query history can keep up to 50 KB of queries, which represents about 200 large queries, or about 300 short queries.
  - <applies-to>Elastic Stack: Generally available from 9.0 to 9.1</applies-to> The query history keeps your 20 most recent queries.
</note>


### Query help

ES|QL features in-app help, inline suggestions, and an autocomplete menu so you can get started faster and don’t have to leave the application to check syntax.
![The ES|QL syntax reference and the autocomplete menu](https://www.elastic.co/docs/explore-analyze/images/kibana-esql-in-app-help.png)

### Starred queries

From the query history, you can mark some queries as favorite to find and access them faster later.
In the query bar, click **Show recent queries**.
From the **Recent** tab, you can star any queries you want.
In the **Starred** tab, find all the queries you have previously starred.
![esql discover query starred](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-discover-query-starred.png)


### Organize the query results

For the example query, the results table shows 10 rows. Omitting the `LIMIT` command, the results table defaults to up to 1000 rows. Using `LIMIT`, you can increase the limit to up to 10,000 rows.
<note>
  The 10,000 row limit only applies to the number of rows that are retrieved by the query and displayed in Discover. Any query or aggregation runs on the full data set.
</note>

Each row shows two columns for the example query: a column with the `@timestamp` field and a column with the full document. To display specific fields from the documents, use the [`KEEP`](https://www.elastic.co/docs/reference/query-languages/esql/commands/keep) command:
```esql
FROM kibana_sample_data_logs
| KEEP @timestamp, bytes, geo.dest
```

To display all fields as separate columns, use `KEEP *`:
```esql
FROM kibana_sample_data_logs
| KEEP *
```

<note>
  The maximum number of columns in Discover is 50. If a query returns more than 50 columns, Discover only shows the first 50.
</note>


### Sorting

To sort on one of the columns, click the column name you want to sort on and select the sort order. Note that this performs client-side sorting. It only sorts the rows that were retrieved by the query, which may not be the full dataset because of the (implicit) limit. To sort the full data set, use the [`SORT`](https://www.elastic.co/docs/reference/query-languages/esql/commands/sort) command:
```esql
FROM kibana_sample_data_logs
| KEEP @timestamp, bytes, geo.dest
| SORT bytes DESC
```


### Time filtering

To display data within a specified time range, you can use the standard time filter, custom time parameters, or a WHERE command.

#### Standard time filter

The standard [time filter](https://www.elastic.co/docs/explore-analyze/query-filter/filtering) is enabled when the indices you’re querying have a field named `@timestamp`.

#### Custom time parameters

If your indices do not have a field named `@timestamp`, you can use the `?_tstart` and `?_tend` parameters to specify a time range. These parameters work with any timestamp field and automatically sync with the [time filter](https://www.elastic.co/docs/explore-analyze/query-filter/filtering).
```esql
FROM my_index
| WHERE custom_timestamp >= ?_tstart AND custom_timestamp < ?_tend
```

You can also use the `?_tstart` and `?_tend` parameters with the [`BUCKET`](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/grouping-functions#esql-bucket) function to create auto-incrementing time buckets in ES|QL [visualizations](#esql-kibana-visualizations). For example:
```esql
FROM kibana_sample_data_logs
| STATS average_bytes = AVG(bytes) BY BUCKET(@timestamp, 50, ?_tstart, ?_tend)
```

This example uses `50` buckets, which is the maximum number of buckets.

#### WHERE command

You can also limit the time range using the [`WHERE`](https://www.elastic.co/docs/reference/query-languages/esql/commands/where) command and the [`NOW`](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-now) function. For example, if the timestamp field is called `timestamp`, to query the last 15 minutes of data:
```esql
FROM kibana_sample_data_logs
| WHERE timestamp > NOW() - 15minutes
```


### Create controls with ES|QL variables

ES|QL variables help you add interactive controls to your queries and make them more dynamic.
They're available for:
- [Discover queries](/docs/explore-analyze/discover/try-esql#add-variable-control) <applies-to>Elastic Stack: Generally available since 9.2</applies-to>
- [ES|QL visualizations in dashboards](/docs/explore-analyze/dashboards/add-controls#add-variable-control)

1. While you edit your ES|QL query, the autocomplete menu suggests adding a control when relevant or when you type `?` in the query. Select **Create control**.
   ![ES|QL query prompting to add a control](https://www.elastic.co/docs/explore-analyze/images/esql-visualization-control-suggestion.png)
2. A menu opens to let you configure the control. This is where you can specify:
   - The type of the control.
  - For controls with **Static values**, enter available controls manually or select them from the dropdown list.
- For controls with **Values from a query**, write an ES|QL query to populate the list of options. This option is useful for dynamically retrieving control values or perform advanced actions such as [defining chaining controls](/docs/explore-analyze/dashboards/add-controls#chain-variable-controls).
  <tip>
  By linking the control to the global time range, the control only shows values that exist within the time range selected in the dashboard or Discover session. You can do that by specifying `WHERE @timestamp <= ?_tend AND @timestamp > ?_tstart` in the control's query, or [custom time parameters](#_custom_time_parameters) if your indices don't have a `@timestamp` field.
  </tip>
- The name of the control. You use this name to reference the control in ES|QL queries.
  - Start the name with `?` if you want the options to be simple static values.
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> Start the name with `??` if you want the options to be fields or functions.
- The values users can select for this control. You can add multiple values from suggested fields, or type in custom values. If you selected **Values from a query**, you must instead write an ES|QL query at this step.
- The label of the control. This is the label displayed in **Discover** or in the dashboard.
- The width of the control.
- Whether the control should allow selecting a single value or multiple values. This [requires using the `MV_CONTAINS` function in your query](#esql-multi-values-controls). <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
   ![ES|QL control settings](https://www.elastic.co/docs/explore-analyze/images/esql-visualization-control-settings.png "title")
3. Save the control.

The variable is inserted into your query, and the control appears.
**Examples**
- Integrate filtering into your ES|QL experience
  ```esql
  | WHERE field == ?value
  ```
- Fields in controls for dynamic group by
  ```esql
  | STATS count=COUNT(*) BY ??field
  ```
- Variable time ranges? Bind function configuration settings to a control
  ```esql
  | BUCKET(@timestamp, ?interval),
  ```
- Make the function itself dynamic
  ```esql
  | STATS metric = ??function
  ```


#### Allow multi-value selections for ES|QL-based variable controls

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

You can create controls that let users select multiple values. To do that:
1. Add the [`MV_CONTAINS`](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_contains) function to your query, and [create a variable](#add-variable-control) as one of its parameters. For example:
   ```esql
   FROM logs-* | WHERE MV_CONTAINS(?values, field)
   ```
   <note>
   Multi-selection is only available for `?values` variables. It is not available for `??fields` and `??functions` variables.
   </note>
2. When defining the control, select the **Allow multiple selections** option.
3. Save the control.

The newly configured control becomes available and allows users to select multiple values.

### LOOKUP JOINs

The ESQL editor supports [`LOOKUP JOIN`](https://www.elastic.co/docs/reference/query-languages/esql/commands/lookup-join) commands and suggests lookup mode indices and join condition fields.
<applies-to>Elastic Stack: Generally available since 9.2</applies-to> Remote lookup joins are supported in [cross-cluster queries](https://www.elastic.co/docs/reference/query-languages/esql/esql-cross-clusters). The lookup index must exist on _all_ remote clusters being queried, because each cluster uses its local lookup index data.
![Using the LOOKUP JOIN command to autocomplete an ES|QL query](https://images.contentstack.io/v3/assets/bltefdd0b53724fa2ce/blte43a30a93241d650/67c23670045f5839e5bfd1e4/lookup-join-demo.gif)
In **Discover**, LOOKUP JOIN commands let you create or edit lookup indices directly from the editor. Find more information in [Using ES|QL > Create and edit lookup indices from queries](/docs/explore-analyze/discover/try-esql#discover-esql-lookup-join).

### Keyboard shortcuts

The ESQL editor supports several shortcuts to help you write and run your queries faster:

| Mac           | Windows/Linux  | Description                 |
|---------------|----------------|-----------------------------|
| `Cmd + Enter` | `Ctrl + Enter` | Run a query                 |
| `Cmd + /`     | `Ctrl + /`     | Comment or uncomment a line |

<tip>
  You can find the list of shortcuts directly from the editor. Look for the ![keyboard](https://www.elastic.co/docs/explore-analyze/images/keyboard.svg "keyboard") icon.
</tip>


## Analyze and visualize data

Between the query bar and the results table, Discover shows a date histogram visualization. By default, if the indices you’re querying do not contain a `@timestamp` field, the histogram is not shown. But you can use a custom time field with the `?_tstart` and `?_tend` parameters to enable it.
The visualization adapts to the query. A query’s nature determines the type of visualization. For example, this query aggregates the total number of bytes per destination country:
```esql
FROM kibana_sample_data_logs
| STATS total_bytes = SUM(bytes) BY geo.dest
| SORT total_bytes DESC
| LIMIT 3
```

The resulting visualization is a bar chart showing the top 3 countries:
![esql kibana bar chart](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-bar-chart.png)

To make changes to the visualization, like changing the visualization type, axes and colors, click the pencil button (![esql icon edit visualization](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-icon-edit-visualization.svg)). This opens an in-line editor:
![esql kibana in line editor](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-in-line-editor.png)

You can save the visualization to a new or existing dashboard by clicking the save button (![esql icon save visualization](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-icon-save-visualization.svg)). Once saved to a dashboard, you’ll be taken to the Dashboards page. You can continue to make changes to the visualization. Click the options button in the top-right (![esql icon options](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-icon-options.svg)) and select **Edit ESQL visualization** to open the in-line editor:
![esql kibana edit on dashboard](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-edit-on-dashboard.png)


### Add a panel to a dashboard

You can use ES|QL queries to create panels on your dashboards. To add a panel to a dashboard, under **Dashboards**, click the **Add panel** button and select ES|QL.
Check the ES|QL query by clicking the Panel filters button (![Panel filters button on panel header](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-dashboard_panel_filter_button.png)):
![esql dashboard panel query](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-dashboard-panel-query.png)

You can also edit the ES|QL visualization from here. Click the options button in the top-right (![esql icon options](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-icon-options.svg)) and select **Edit ESQL visualization** to open the in-line editor.
![esql dashboard panel edit visualization](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-dashboard-panel-edit-visualization.png)

You can also [Add dashboard controls from your ES|QL visualization's query](/docs/explore-analyze/dashboards/add-controls#add-variable-control)

## Create an enrich policy

The ES|QL [`ENRICH`](https://www.elastic.co/docs/reference/query-languages/esql/commands/enrich) command enables you to [enrich](https://www.elastic.co/docs/reference/query-languages/esql/esql-enrich-data) your query dataset with fields from another dataset. Before you can use `ENRICH`, you need to [create and execute an enrich policy](https://www.elastic.co/docs/reference/query-languages/esql/esql-enrich-data#esql-set-up-enrich-policy). If a policy exists, it will be suggested by autocomplete. If not, click **Click to create** to create one.
![esql kibana enrich autocomplete](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-enrich-autocomplete.png)

Next, you can enter a policy name, the policy type, source indices, and optionally a query:
![esql kibana enrich step 1](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-enrich-step-1.png)

Click **Next** to select the match field and enrich fields:
![esql kibana enrich step 2](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-enrich-step-2.png)

Finally, click **Create and execute**.
Now, you can use the enrich policy in an ES|QL query:
```esql
FROM kibana_sample_data_logs
| STATS total_bytes = SUM(bytes) BY geo.dest
| SORT total_bytes DESC
| LIMIT 3
| ENRICH countries
```


## Create an alerting rule

You can use ES|QL queries to create alerts. From Discover, click **Alerts** and select **Create search threshold rule**. This opens a panel that enables you to create a rule using an ES|QL query. Next, you can test the query, add a connector, and save the rule.
![esql kibana create rule](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-esql-kibana-create-rule.png)


## Limitations

- The user interface to filter data is not enabled when Discover is in ES|QL mode. To filter data, write a query that uses the [`WHERE`](https://www.elastic.co/docs/reference/query-languages/esql/commands/where) command instead.
- Discover shows no more than 10,000 rows. This limit only applies to the number of rows that are retrieved by the query and displayed in Discover. Queries and aggregations run on the full data set.
- Discover shows no more than 50 columns. If a query returns more than 50 columns, Discover only shows the first 50.
- CSV export from Discover shows no more than 10,000 rows. This limit only applies to the number of rows that are retrieved by the query and displayed in Discover. Queries and aggregations run on the full data set.
- Querying many indices at once without any filters can cause an error in kibana which looks like `[esql] > Unexpected error from Elasticsearch: The content length (536885793) is bigger than the maximum allowed string (536870888)`. The response from ES|QL is too long. Use [`DROP`](https://www.elastic.co/docs/reference/query-languages/esql/commands/drop) or [`KEEP`](https://www.elastic.co/docs/reference/query-languages/esql/commands/keep) to limit the number of fields returned.