﻿---
title: Query languages
description: Elasticsearch provides a number of query languages for interacting with your data. You can use these languages programmatically when working with Elasticsearch...
url: https://www.elastic.co/docs/explore-analyze/query-filter/languages
products:
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Query languages
Elasticsearch provides a number of query languages for interacting with your data. You can use these languages programmatically when working with Elasticsearch and Kibana APIs in your application, or interactively using the Kibana UI.

| Name                            | Description                                                                                                                                                                                                                                           | Use cases                                                                                                                                                                                                                                  | API endpoint                                                                              |
|---------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------|
| **Query DSL**                   | Elasticsearch's primary, most powerful and flexible JSON-style language for complex queries.[Full language reference](https://www.elastic.co/docs/reference/query-languages/querydsl)                                                                 | Full-text search, semantic search, keyword search, filtering, aggregations, and more. [Query DSL in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl)                                                   | [`_search`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) |
| **ES|QL**                       | Introduced in **8.11**, the Elasticsearch Query Language (ES|QL) is a piped query language for filtering, transforming, and analyzing data.[Full language reference](https://www.elastic.co/docs/reference/query-languages/esql)                      | You can use ES|QL in multiple Kibana applications for querying, visualizing, and analyzing data.[ES|QL in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/esql-kibana)                                          | [`_query`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-esql)         |
| **EQL**                         | Event Query Language (EQL) is a query language for event-based time series data. Data must contain the `@timestamp` field to use EQL.[Full language reference](https://www.elastic.co/docs/reference/query-languages/eql)                             | Designed for the threat hunting security use case.[EQL in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/eql)                                                                                                  | [`_eql`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-eql)            |
| **Elasticsearch SQL**           | Allows native, real-time SQL-like querying against Elasticsearch data. JDBC and ODBC drivers are available for integration with business intelligence (BI) tools.[Full language reference](https://www.elastic.co/docs/reference/query-languages/sql) | Query Elasticsearch data using a familiar SQL syntax for BI and reporting.[Elasticsearch SQL in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/sql)                                                            | [`_sql`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-sql)            |
| **Kibana Query Language (KQL)** | Kibana Query Language (KQL) is a text-based query language for filtering data when you access it through the Kibana UI.                                                                                                                               | Use KQL to filter documents where a value for a field exists, matches a given value, or is within a given range.[KQL in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql)                                    | N/A                                                                                       |
| **Lucene query syntax**         | The original query syntax for Elasticsearch, based on Apache Lucene. Simple text-based syntax for basic searches and filtering.                                                                                                                       | Perform basic text searches, simple field queries, and wildcard searches. Useful for quick searches and simple filtering.[Lucene syntax in Kibana](https://www.elastic.co/docs/explore-analyze/query-filter/languages/lucene-query-syntax) | [`_search`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) |