﻿---
title: Filtering in Kibana
description: This page describes the common ways Kibana offers in most apps for filtering data and refining your initial search queries. Some apps provide more options,...
url: https://www.elastic.co/docs/explore-analyze/query-filter/filtering
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Filtering in Kibana
This page describes the common ways Kibana offers in most apps for filtering data and refining your initial search queries.
Some apps provide more options, such as [Dashboards](https://www.elastic.co/docs/explore-analyze/dashboards).

## Time filter

Display data within a specified time range when your index contains time-based events, and a time-field is configured for the selected [data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views). The default time range is 15 minutes, but you can customize it in [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings).
1. Click ![calendar icon](https://www.elastic.co/docs/explore-analyze/images/kibana-time-filter-icon.png "calendar icon").
2. Choose one of the following:
   - **Quick select**. Set a time based on the last or next number of seconds, minutes, hours, or other time unit.
- **Commonly used**. Select a time range from options such as **Last 15 minutes**, **Today**, and **Week to date**.
- **Recently used date ranges**. Use a previously selected data range.
- **Refresh every**. Specify an automatic refresh rate.

![Time filter menu](https://www.elastic.co/docs/explore-analyze/images/kibana-time-filter.png)

1. To set start and end times, click the bar next to the time filter. In the popup, select **Absolute**, **Relative** or **Now**, then specify the required options.

![Time filter showing relative time](https://www.elastic.co/docs/explore-analyze/images/kibana-time-relative.png)

The global time filter limits the time range of data displayed. In most cases, the time filter applies to the time field in the data view, but some apps allow you to use a different time field.
Using the time filter, you can configure a refresh rate to periodically resubmit your searches.
To manually resubmit a search, click the **Refresh** button. This is useful when you use Kibana to view the underlying data.

## Additional filters

Structured filters are a more interactive way to create Elasticsearch queries, and are commonly used when building dashboards that are shared by multiple analysts. Each filter can be disabled, inverted, or pinned across all apps. Each of the structured filters is combined with AND logic on the rest of the query.
![Add filter popup](https://www.elastic.co/docs/explore-analyze/images/kibana-add-filter-popup.png)