﻿---
title: Setting up machine learning
description: To use the Elastic Stack machine learning features, you must have: the appropriate subscription level or the free trial period activated, xpack.ml.enabled...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/setting-up-machine-learning
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Setting up machine learning
## Requirements overview

To use the Elastic Stack machine learning features, you must have:
- the [appropriate subscription](https://www.elastic.co/subscriptions) level or the free trial period activated
- `xpack.ml.enabled` set to its default value of `true` on every node in the cluster (refer to [Machine learning settings in Elasticsearch](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/machine-learning-settings))
- `ml` value defined in the list of `node.roles` on the [machine learning nodes](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#ml-node)
- machine learning features visible in the Kibana space
- security privileges assigned to the user that:
  - grant use of machine learning features, and
- grant access to source and destination indices.

<tip>
  The fastest way to get started with machine learning features is to [start a free 14-day trial of Elastic Cloud](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
</tip>


## Security privileges

Assigning security privileges affects how users access machine learning features. Consider the two main categories:
- **[Elasticsearch API user](#es-security-privileges)**: uses an Elasticsearch client, cURL, or Kibana Dev Tools to access machine learning features via Elasticsearch APIs. It requires Elasticsearch security privileges.
- **[Kibana user](#kib-security-privileges)**: uses the machine learning features in Kibana and does not use Dev Tools. It requires either Kibana feature privileges or Elasticsearch security privileges and is granted the most permissive combination of both. Kibana feature privileges are recommended if you control job level visibility via **Spaces**. Machine learning features must be visible in the relevant space. Refer to [Feature visibility in Spaces](#kib-visibility-spaces) for configuration information.

You can configure these privileges
- under the **Roles** and **Spaces** management pages. Find these pages in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
- via the respective Elasticsearch security APIs.


### Elasticsearch API user

If you use machine learning APIs, you must have the following cluster and index privileges:
For full access:
- `machine_learning_admin` built-in role or the equivalent cluster privileges
- `read` and `view_index_metadata` on source indices
- `read`, `manage`, and `index` on destination indices (for data frame analytics analytics jobs only)

For read-only access:
- `machine_learning_user` built-in role or the equivalent cluster privileges
- `read` index privileges on source indices
- `read` index privileges on destination indices (for data frame analytics analytics jobs only)

<important>
  The `machine_learning_admin` and `machine_learning_user` built-in roles give access to the results of *all* anomaly detection jobs, irrespective of whether the user has access to the source indices. You must carefully consider who is given these roles, as anomaly detection job results may propagate field values that contain sensitive information from the source indices to the results.
</important>


### Kibana security

<important>
  Granting `All` or `Read` Kibana feature privilege for Machine Learning will also grant the role the equivalent feature privileges to certain types of Kibana saved objects, namely data views, dashboards, discover sessions, and visualizations as well as machine learning job, trained model and module saved objects.
</important>


#### Feature visibility in Spaces

In Kibana, the machine learning features must be visible in your [space](https://www.elastic.co/docs/deploy-manage/manage-spaces). To manage which features are visible in your space, go to the **Spaces** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
![Manage spaces in Kibana](https://www.elastic.co/docs/explore-analyze/images/machine-learning-spaces.jpg)

In addition to index privileges, source data views must also exist in the same space as your machine learning jobs. You can configure these under **Data Views**. To open **Data Views**, find **Stack Management** > **Kibana** in the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
Each machine learning job and trained model can be assigned to all, one, or multiple spaces. This can be configured in **Machine Learning**. To open **Machine Learning**, find the page in the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). You can edit the spaces that a job or model is assigned to by clicking the icons in the **Spaces** column.
![Assign machine learning jobs to spaces](https://www.elastic.co/docs/explore-analyze/images/machine-learning-assign-job-spaces.jpg)


#### Kibana user

Within a Kibana space, for full access to the machine learning features, you must have:
- `Machine Learning: All` Kibana privileges
- `Data Views Management: All` Kibana feature privileges
- `read`, and `view_index_metadata` index privileges on your source indices
- data views for your source indices
- data views, `read`, `manage`, and `index` index privileges on destination indices (for data frame analytics analytics jobs only)

Within a Kibana space, for read-only access to the machine learning features, you must have:
- `Machine Learning: Read` Kibana privileges
- data views for your source indices
- `read` index privilege on your source indices
- data views and `read` index privileges on destination indices (for data frame analytics analytics jobs only)

<important>
  A user who has full or read-only access to machine learning features within a given Kibana space can view the results of *all* anomaly detection jobs that are visible in that space, even if they do not have access to the source indices of those jobs. You must carefully consider who is given access to machine learning features, as anomaly detection job results may propagate field values that contain sensitive information from the source indices to the results.
</important>

<note>
  Data views can be automatically created when creating a data frame analytics analytics job.
</note>

For access to use machine learning APIs via *Dev Tools* in Kibana, set the Elasticsearch security privileges and grant access to `machine_learning_admin` or `machine_learning_user` built-in roles.

#### Data Visualizer feature

Within a Kibana space, to upload and import files in the **Data Visualizer**, you must have:
- `Machine Learning: Read` or `Discover: All` Kibana feature privileges
- `Data Views Management: All` Kibana feature privileges
- `ingest_admin` built-in role, or `manage_ingest_pipelines` cluster privilege
- `create`, `create_index`, `manage` and `read` index privileges for destination indices

For more information, see [Security privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges) and [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).

## Export and import machine learning jobs

Export and import [anomaly detection jobs](#move-anomaly-detection-jobs) and [data frame analytics jobs](#move-dataframe-analytics-jobs) to transfer them between clusters or environments, for example, from a test environment to production.
<note>
  The exported files contain configuration details only; they do not contain the machine learning models.
</note>


### Export and import anomaly detection jobs


#### Prerequisites

- If your anomaly detection jobs use [custom rules](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-detector-custom-rules) with filter lists, the filter lists must exist; otherwise, the import fails. To create filter lists, use Kibana or the [create filters API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-filter)
- If your anomaly detection jobs were associated with [calendars](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-calendars), you must create the calendar in the new environment and add your imported jobs to the calendar. Use Kibana or the [create calendars](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-calendar), [add events to calendar](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-post-calendar-events), and [add jobs to calendar](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-calendar-job) APIs.


#### Export anomaly detection jobs

1. To navigate to **Anomaly detection jobs**, use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Export jobs**.
3. Select the jobs, then click **Export** to download the job definition file.


#### Import anomaly detection jobs

1. To navigate to **Anomaly detection jobs**, use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Import jobs**.
3. Upload the file that defines the anomaly detection job.
4. Enter a job ID and click **Import**.

<important>
  Anomaly detection jobs can be imported even if their data views or underlying indices are missing. In these cases, warnings are displayed, but the import is still allowed. Any issues raised by these warnings can be resolved later by adding the missing data views.
</important>

After importing an anomaly detection job, you must run it so that it can learn from your current data and build a model that reflects the new environment.

### Export and import data frame analytics jobs

<note>
  For data frame analytics, trained models are portable and can be transferred between clusters as described in [Exporting and importing models](/docs/explore-analyze/machine-learning/data-frame-analytics/ml-trained-models#export-import).
</note>


#### Prerequisites

- Data frame analytics jobs require their source index to exist before they can be imported. If the source index is missing, the import fails.


#### Export data frame analytics jobs

1. To navigate to **Data frame analytics**, use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Export jobs**.
3. Select the jobs, then click **Export** to download the job definition file.


#### Import data frame analytics jobs

1. To navigate to **Data frame analytics**, use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Import jobs**.
3. Select the file that defines the data frame analytics job.
4. Enter a job ID and a destination index, then click **Import**.