﻿---
title: Select a trained model
description: Per the Overview, there are multiple ways that you can use NLP features within the Elastic Stack. After you determine which type of NLP task you want...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-select-model
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Select a trained model
Per the [Overview](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-overview), there are multiple ways that you can use NLP features within the Elastic Stack. After you determine which type of NLP task you want to perform, you must choose an appropriate trained model.
The simplest method is to use a model that has already been fine-tuned for the type of analysis that you want to perform. For example, there are models and data sets available for specific NLP tasks on [Hugging Face](https://huggingface.co/models). These instructions assume you’re using one of those models and do not describe how to create new models. For the current list of supported model architectures, refer to [Compatible third party models](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-model-ref).
If you choose to perform language identification by using the `lang_ident_model_1` that is provided in the cluster, no further steps are required to import or deploy the model. You can skip to using the model in [ingestion pipelines](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-inference).