﻿---
title: Import the trained model and vocabulary
description: After you choose a model, you must import it and its tokenizer vocabulary to your cluster. When you import the model, it must be chunked and imported...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-import-model
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Import the trained model and vocabulary
<warning>
  PyTorch models can execute code on your Elasticsearch server, exposing your cluster to potential security vulnerabilities.**Only use models from trusted sources and never use models from unverified or unknown providers.**
</warning>

<important>
  If you want to install a trained model in a restricted or closed network, refer to [these instructions](https://www.elastic.co/docs/reference/elasticsearch/clients/eland/machine-learning#ml-nlp-pytorch-air-gapped).
</important>

After you choose a model, you must import it and its tokenizer vocabulary to your cluster. When you import the model, it must be chunked and imported one chunk at a time for storage in parts due to its size.
<note>
  Trained models must be in a TorchScript representation for use with Elastic Stack machine learning features.
</note>

[Eland](https://github.com/elastic/eland) is an Elasticsearch Python client that provides a simple script to perform the conversion of Hugging Face transformer models to their TorchScript representations, the chunking process, and upload to Elasticsearch; it is therefore the recommended import method. You can either install the Python Eland client on your machine or use a Docker image to build Eland and run the model import script.

## Import with the Eland client installed

1. Install the [Eland Python client](https://www.elastic.co/docs/reference/elasticsearch/clients/eland/installation) with PyTorch extra dependencies.
   ```shell
   python -m pip install 'eland[pytorch]'
   ```
2. Run the `eland_import_hub_model` script to download the model from Hugging Face, convert it to TorchScript format, and upload to the Elasticsearch cluster. For example:
   ```
   eland_import_hub_model \
   --cloud-id <cloud-id> \ 
   -u <username> -p <password> \ 
   --hub-model-id elastic/distilbert-base-cased-finetuned-conll03-english \ 
   --task-type ner  
   ```

For more details, refer to the [Eland documentation](https://www.elastic.co/docs/reference/elasticsearch/clients/eland/machine-learning#ml-nlp-pytorch).

## Import with Docker

If you want to use Eland without installing it, run the following command:
```bash
$ docker run -it --rm --network host docker.elastic.co/eland/eland
```

The `eland_import_hub_model` script can be run directly in the docker command:
```bash
docker run -it --rm docker.elastic.co/eland/eland \
    eland_import_hub_model \
      --url $ELASTICSEARCH_URL \
      --hub-model-id elastic/distilbert-base-uncased-finetuned-conll03-english \
      --start
```

Replace the `$ELASTICSEARCH_URL` with the URL for your Elasticsearch cluster. Refer to [Authentication methods](#ml-nlp-authentication) to learn more.

## Authentication methods

The following authentication options are available when using the import script:
- username/password authentication (specified with the `-u` and `-p` options):

```bash
eland_import_hub_model --url https://<hostname>:<port> -u <username> -p <password> ...
```

- username/password authentication (embedded in the URL):

```bash
eland_import_hub_model --url https://<user>:<password>@<hostname>:<port> ...
```

- API key authentication:

```bash
eland_import_hub_model --url https://<hostname>:<port> --es-api-key <api-key> ...
```