﻿---
title: Inference processing
description: When you create an index through the Content UI, a set of default ingest pipelines are also created, including a machine learning inference pipeline...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/machine-learning-in-kibana/inference-processing
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Inference processing
When you create an index through the **Content** UI, a set of default ingest pipelines are also created, including a machine learning inference pipeline. The [ML inference pipeline](/docs/solutions/search/search-pipelines#ingest-pipeline-search-details-specific-ml-reference) uses inference processors to analyze fields and enrich documents with the output. Inference processors use ML trained models, so you need to use a built-in model or [deploy a trained model in your cluster](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-deploy-models) to use this feature.
This guide focuses on the ML inference pipeline, its use, and how to manage it.
<important>
  This feature is not available at all Elastic subscription levels. Refer to the Elastic subscriptions pages for [Elastic Cloud](https://www.elastic.co/subscriptions/cloud) and [self-managed](https://www.elastic.co/subscriptions) deployments.
</important>


## NLP use cases

[Natural Language Processing (NLP)](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-overview) enables developers to create rich search experiences that go beyond the standards of lexical search. A few examples of ways to improve search experiences through the use of NLP models:

### ELSER text expansion

Using Elastic's [ELSER machine learning model](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-elser) you can incorporate text expansion for your queries. This works by using ELSER to provide semantic enrichments to your documents upon ingestion, combined with the power of [Elastic Search Application templates](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-applications) to provide automated text expansion at query time.

### Named entity recognition (NER)

Most commonly used to detect entities such as People, Places, and Organization information from text, [NER](/docs/explore-analyze/machine-learning/nlp/ml-nlp-extract-info#ml-nlp-ner) can be used to extract key information from text and group results based on that information. A sports news media site could use NER to automatically extract names of professional athletes, stadiums, and sports teams in their articles and link to season stats or schedules.

### Text classification

[Text classification](/docs/explore-analyze/machine-learning/nlp/ml-nlp-classify-text#ml-nlp-text-classification) is commonly used for sentiment analysis and can be used for similar tasks, such as labeling content as containing hate speech in public forums, or triaging and labeling support tickets so they reach the correct level of escalation automatically.

### Text embedding

Analyzing a text field using a [Text embedding](/docs/explore-analyze/machine-learning/nlp/ml-nlp-search-compare#ml-nlp-text-embedding) model will generate a [dense vector](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/dense-vector) representation of the text. This array of numeric values encodes the semantic *meaning* of the text. Using the same model with a user’s search query will produce a vector that can then be used to search, ranking results based on vector similarity - semantic similarity - as opposed to traditional word or text similarity.
A common use case is a user searching FAQs, or a support agent searching a knowledge base, where semantically similar content may be indexed with little similarity in phrasing.

## NLP in the Content UI


### Overview of the ML inference pipeline

The diagram below shows how documents are processed during ingestion.
![ML inference pipeline diagram](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-document-enrichment-diagram.png)

- Documents are processed by the `my-index-0001` pipeline, which happens automatically when indexing through a an Elastic connector or crawler.
- The `_run_ml_inference` field is set to `true` to ensure the ML inference pipeline (`my-index-0001@ml-inference`) is executed. This field is removed during the ingestion process.
- The inference processor analyzes the `message` field on the document using the `my-positivity-model-id` trained model. The inference output is stored in the `ml.inference.positivity_prediction` field.
- The resulting enriched document is then indexed into the `my-index-0001` index.
- The `ml.inference.positivity_prediction` field can now be used at query time to search for documents above or below a certain threshold.


## Find, deploy, and manage trained models

This feature is intended to make it easier to use your ML trained models. First, you need to figure out which model works best for your data. Make sure to use a [compatible third party NLP model](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-model-ref). Since these are publicly available, it is not possible to fine-tune models before [deploying them](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-deploy-models).
Trained models must be available in the current [Kibana Space](https://www.elastic.co/docs/deploy-manage/manage-spaces) and running in order to use them. By default, models should be available in all Kibana Spaces that have the **Analytics** > **Machine Learning** feature enabled. To manage your trained models, use the Kibana UI and navigate to **Stack Management → Machine Learning → Trained Models**. Spaces can be controlled in the **spaces** column. To stop or start a model, go to the **Machine Learning** tab in the **Analytics** menu of Kibana and click **Trained Models** in the **Model Management** section.
<note>
  The `monitor_ml` [Elasticsearch cluster privilege](https://www.elastic.co/docs/reference/elasticsearch/security-privileges) is required to manage ML models and ML inference pipelines which use those models.
</note>


### Add inference processors to your ML inference pipeline

To create the index-specific ML inference pipeline, go to **Search → Content → Indices → <your index> → Pipelines** in the Kibana UI.
If you only see the `search-default-ingestion` pipeline, you will need to click **Copy and customize** to create index-specific pipelines. This will create the `{{index_name}}@ml-inference` pipeline.
Once your index-specific ML inference pipeline is ready, you can add inference processors that use your ML trained models. To add an inference processor to the ML inference pipeline, click the **Add Inference Pipeline** button in the **Machine Learning Inference Pipelines** card.
![Add Inference Pipeline](https://www.elastic.co/docs/explore-analyze/images/elasticsearch-reference-document-enrichment-add-inference-pipeline.png)

Here, you’ll be able to:
1. Choose a name for your pipeline.
   - This name will need to be unique across the whole deployment. If you want this pipeline to be index-specific, we recommend including the name of your index in the pipeline name.
- If you do not set the pipeline name, a default unique name will be provided upon selecting a trained model.
2. Select the ML trained model you want to use.
   - The model must be deployed before you can select it. To begin deployment of a model, click the **Deploy** button.
3. Select one or more source fields as input for the inference processor.
   - If there are no source fields available, your index will need a [field mapping](https://www.elastic.co/docs/manage-data/data-store/mapping).
4. (Optional) Choose a name for your target field(s). This is where the output of the inference model will be stored. Changing the default name is only possible if you have a single source field selected.
5. Add the source-target field mapping to the configuration by clicking the **Add** button.
6. Repeat steps 3-5 for each field mapping you want to add.
7. (Optional) Test the pipeline with a sample document.
8. (Optional) Review the pipeline definition before creating it with the **Create pipeline** button.


### Manage and delete inference processors from your ML inference pipeline

Inference processors added to your index-specific ML inference pipelines are normal Elasticsearch pipelines. Once created, each processor will have options to **View in Stack Management** and **Delete Pipeline**. Deleting an inference processor from within the **Content** UI deletes the pipeline and also removes its reference from your index-specific ML inference pipeline.
These pipelines can also be viewed, edited, and deleted in Kibana from the **Ingest Pipelines** management page, just like all other Elasticsearch ingest pipelines. You may also use the [Ingest pipeline APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ingest). If you delete any of these pipelines outside of the **Content** UI in Kibana, make sure to edit the ML inference pipelines that reference them.

## Test your ML inference pipeline

You can verify the expected structure of the inference output before indexing any documents while creating the machine learning inference pipeline under the **Test** tab. Provide a sample document, click **Simulate**, and look for the `ml.inference` object in the results.
To ensure the ML inference pipeline will be run when ingesting documents, you must make sure the documents you are ingesting have a field named `_run_ml_inference` that is set to `true` and you must set the pipeline to `{{index_name}}`. For connector and crawler indices, this will happen automatically if you’ve configured the settings appropriately for the pipeline name `{{index_name}}`. To manage these settings:
1. Go to **Search > Content > Indices > <your index> > Pipelines**.
2. Click on the **Settings** link in the **Ingest Pipelines** card for the `{{index_name}}` pipeline.
3. Ensure **ML inference pipelines** is selected. If it is not, select it and save the changes.


## Learn More

- See [Overview](/docs/solutions/search/search-pipelines#ingest-pipeline-search-in-enterprise-search) for information on the various pipelines that are created.
- Learn about [ELSER](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-elser), Elastic’s proprietary retrieval model for semantic search with sparse vectors.
- [NER HuggingFace Models](https://huggingface.co/models?library=pytorch&pipeline_tag=token-classification&sort=downloads)
- [Text Classification HuggingFace Models](https://huggingface.co/models?library=pytorch&pipeline_tag=text-classification&sort=downloads)
- [Text Embedding HuggingFace Models](https://huggingface.co/models?library=pytorch&pipeline_tag=sentence-similarity&sort=downloads)