﻿---
title: Feature encoding
description: Machine learning models can only work with numerical values. For this reason, it is necessary to transform the categorical values of the relevant features...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-feature-encoding
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Feature encoding
Machine learning models can only work with numerical values. For this reason, it is necessary to transform the categorical values of the relevant features into numerical ones. This process is called *feature encoding*.
Data frame analytics automatically performs feature encoding. The input data is pre-processed with the following encoding techniques:
- one-hot encoding: Assigns vectors to each category. The vector represent whether the corresponding feature is present (1) or not (0).
- target-mean encoding: Replaces categorical values with the mean value of the target variable.
- frequency encoding: Takes into account how many times a given categorical value is present in relation with a feature.

When the model makes predictions on new data, the data needs to be processed in the same way it was trained. Machine learning model inference in the Elastic Stack does this automatically, so the automatically applied encodings are used in each call for inference. Refer to inference for [classification](/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-classification#ml-inference-class) and [regression](/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-regression#ml-inference-reg).
[Feature importance](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-feature-importance) is calculated for the original categorical fields, not the automatically encoded features.