﻿---
title: Data frame analytics API quick reference
description: All data frame analytics endpoints have the following base: The evaluation API endpoint has the following base: Create data frame analytics analytics...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfanalytics-apis
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Data frame analytics API quick reference
All data frame analytics endpoints have the following base:
```js
/_ml/data_frame/analytics
```

The evaluation API endpoint has the following base:
```js
/_ml/data_frame/_evaluate
```

- [Create data frame analytics analytics jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-data-frame-analytics)
- [Delete data frame analytics analytics jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-delete-data-frame-analytics)
- [Evaluate data frame analytics](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-evaluate-data-frame)
- [Explain data frame analytics](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-explain-data-frame-analytics)
- [Get data frame analytics analytics jobs info](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-data-frame-analytics)
- [Get data frame analytics analytics jobs statistics](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-data-frame-analytics-stats)
- [Preview data frame analytics](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-preview-data-frame-analytics)
- [Start data frame analytics analytics jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-start-data-frame-analytics)
- [Stop data frame analytics analytics jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-stop-data-frame-analytics)
- [Update data frame analytics analytics jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-update-data-frame-analytics)

For information about the APIs related to trained models, refer to [*API quick reference*](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-apis).