﻿---
title: How data frame analytics jobs work
description: A data frame analytics analytics job is essentially a persistent Elasticsearch task. During its life cycle, it goes through four or five main phases depending...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-phases
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# How data frame analytics jobs work
A data frame analytics analytics job is essentially a persistent Elasticsearch task. During its life cycle, it goes through four or five main phases depending on the analysis type:
- reindexing,
- loading data,
- analyzing,
- writing results,
- inference (regression and classification only).

Let’s take a look at the phases one-by-one.

## Reindexing

During the reindexing phase the documents from the source index or indices are copied to the destination index. If you want to define settings or mappings, create the index before you start the job. Otherwise, the job creates it using default settings.
Once the destination index is built, the data frame analytics analytics job task calls the Elasticsearch [Reindex API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex) to launch the reindexing task.

## Loading data

After the reindexing is finished, the job fetches the needed data from the destination index. It converts the data into the format that the analysis process expects, then sends it to the analysis process.

## Analyzing

In this phase, the job generates a machine learning model for analyzing the data. The specific phases of analysis vary depending on the type of data frame analytics analytics job.
Outlier detection jobs have a single analysis phase called `computing_outliers`, in which they identify outliers in the data.
Regression and classification jobs have four analysis phases:
1. `feature_selection`: Identifies which of the supplied fields are most relevant for predicting the dependent variable.
2. `coarse_parameter_search`: Identifies initial values for undefined hyperparameters.
3. `fine_tuning_parameters`: Identifies final values for undefined hyperparameters. See [hyperparameter optimization](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/hyperparameters).
4. `final_training`: Trains the machine learning model.


## Writing results

After the loaded data is analyzed, the analysis process sends back the results. Only the additional fields that the analysis calculated are written back, the ones that have been loaded in the loading data phase are not. The data frame analytics analytics job matches the results with the data rows in the destination index, merges them, and indexes them back to the destination index.

## Inference

This phase exists only for regression and classification jobs. In this phase, the job validates the trained model against the test split of the data set.
Finally, after all phases are completed, the task is marked as completed and the data frame analytics analytics job stops. Your data is ready to be evaluated.