﻿---
title: Data frame analytics
description: Data frame analytics enable you to perform different analyses of your data and annotate it with the results. Consult Setup and security to learn more...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics
products:
  - Elasticsearch
  - Kibana
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Data frame analytics
<important>
  Using data frame analytics requires source data to be structured as a two dimensional "tabular" data structure, in other words a data frame. [Transforms](https://www.elastic.co/docs/explore-analyze/transforms) enable you to create data frames which can be used as the source for data frame analytics.
</important>

Data frame analytics enable you to perform different analyses of your data and annotate it with the results. Consult [Setup and security](https://www.elastic.co/docs/explore-analyze/machine-learning/setting-up-machine-learning) to learn more about the license and the security privileges that are required to use data frame analytics.
- [Overview](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-overview)
- [*Finding outliers*](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-finding-outliers)
- [*Predicting numerical values with regression*](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-regression)
- [*Predicting classes with classification*](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-classification)
- [*Advanced concepts*](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-concepts)
- [*API quick reference*](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfanalytics-apis)
- [*Resources*](https://www.elastic.co/docs/explore-analyze/machine-learning/data-frame-analytics/ml-dfa-resources)