﻿---
title: Reverting to a model snapshot
description: Snapshots of the machine learning model for each anomaly detection job are saved frequently to an internal Elasticsearch index to ensure resilience. It...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-reverting-model-snapshot
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Reverting to a model snapshot
[Snapshots of the machine learning model](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-model-snapshots) for each anomaly detection job are saved frequently to an internal Elasticsearch index to ensure resilience. It makes it possible to reset the model to a previous state in case of a system failure or if the model changed significantly due to a one-off event.
1. Navigate to the **Anomaly Detection Jobs** page in the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Locate the anomaly detection job whose model you want to revert in the job table.
3. Open the job details and navigate to the **Model Snapshots** tab.
   ![A screenshot of a job with the Model Snapshots tab opened](https://www.elastic.co/docs/explore-analyze/images/machine-learning-anomaly-job-model-snapshots.jpg)
4. Select a snapshot from the list and click the **Revert** icon under **Actions**.
5. Optional: Select if you want to replay the analysis based on the data in your index after the revert has been applied. If you don’t select this option, there will be no anomaly detection results after the snapshot was taken and the job results end at the point in time of the snapshot. If you select this option, you can then optionally select one or both of the next two options:
   - You can select whether you want the job to continue running in real time after the replay, or to just replay existing data after the snapshot.
- You can select a time range you want to avoid during the replay by declaring a calendar event. This way, you can skip any problematic time frame that you want the anomaly detection job to avoid.
   ![A screenshot of a revert model snapshot flyout](https://www.elastic.co/docs/explore-analyze/images/machine-learning-revert-model-snapshot.jpg)
6. Click **Apply**.

<tip>
  You can use [custom rules](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-rules) to avoid a model being updated in case of a known event you want to exclude from the analysis. Using custom rules might help you to avoid situations where you need to revert to a snapshot.
</tip>

Alternatively, you can use the [revert model snapshots](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-revert-model-snapshot) API. In this case, you need to manually close the corresponding job before reverting to the saved snapshot.
<note>
  - By default, when you revert to a snapshot, all anomaly detection results are deleted for the corresponding job after the point when the snapshot was saved. If you replay the analysis, results will be re-generated based on your configuration.
  - Reverting to a snapshot does not change the `data_counts` values of the anomaly detection job, these values are not reverted to the earlier state.
</note>