﻿---
title: Anomaly detection jobs from visualizations
description: You can create anomaly detection jobs from the compatible Lens charts on Dashboard. Only chart-like visualizations are compatible. Supported chart types...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-jobs-from-lens
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Anomaly detection jobs from visualizations
You can create anomaly detection jobs from the compatible Lens charts on **Dashboard**.

## Prerequisites and limitations

- Only chart-like visualizations are compatible. Supported chart types are `area`, `area_percentage_stacked`, `area_stacked`, `bar`, `bar_horizontal`, `bar_horizontal_stacked`, `bar_percentage_stacked`, `bar_stacked`, and `line`.
- Supported anomaly detection functions are `average`, `count`, `max`, `median`, `min`, `sum`, `unique_count`.
- The chart must contain a date field on one axis and it must be the same as the default date field for the data view.
- In case of a multi-layered chart, only the compatible layers can be used to create an anomaly detection job.
- Chart layers which contain a field that uses a [time shift](/docs/explore-analyze/dashboards/create-dashboard-of-panels-with-ecommerce-data#compare-time-ranges) or a field that has a `filter by` setting applied cannot be used to create an anomaly detection job.


## Creating the job

<note>
  You need to have a compatible visualization on **Dashboard** to create an anomaly detection job. If you don’t have one but you want to try the feature out, go to **Analytics > Dashboard** and select the `[Flight] Global Flight Dashboard` which is based on the Kibana sample flight data set. Select the `Flight count` visualization from the dashboard.
</note>

1. Go to **Analytics > Dashboard** from the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Select a dashboard with a compatible visualization.
2. Open the **Options (…) menu** for the panel, then select **More**.
3. Select **Create anomaly detection job**. The option is only displayed if the visualization can be converted to an anomaly detection job configuration.
4. (Optional) Select the layer from which the anomaly detection job is created.

![A screenshot of a chart with the Options menu opened](https://www.elastic.co/docs/explore-analyze/images/machine-learning-create-ad-job-from-lens.jpg)

If the visualization has multiple compatible layers, you can select which layer to use for creating the anomaly detection job.
![A screenshot of a chart with the Options menu opened](https://www.elastic.co/docs/explore-analyze/images/machine-learning-select-layer-for-job.jpg)

If multiple fields are added to the chart or you selected a `Break down by` field, the multi metric job wizard is used for creating the job. For a single metric chart, the single metric wizard is used.
If the configured time range of the chart is relative, it is converted to absolute start and end times in the job configuration. If the conversion of these times fails, the whole time range from the index is used.

## What’s next

- [Learn more about **Dashboard**](https://www.elastic.co/docs/explore-analyze/dashboards)
- [Learn more about creating visualizations with **Lens**](https://www.elastic.co/docs/explore-analyze/visualize/lens)