﻿---
title: Customizing detectors with custom rules
description: Custom rules – or job rules as Kibana refers to them – enable you to change the behavior of anomaly detectors based on domain-specific knowledge. Custom...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-detector-custom-rules
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Customizing detectors with custom rules
[Custom rules](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-rules) – or *job rules* as Kibana refers to them – enable you to change the behavior of anomaly detectors based on domain-specific knowledge.
Custom rules describe *when* a detector should take a certain *action* instead of following its default behavior. To specify the *when* a rule uses a `scope` and `conditions`. You can think of `scope` as the categorical specification of a rule, while `conditions` are the numerical part. A rule can have a scope, one or more conditions, or a combination of scope and conditions. For the full list of specification details, see the [`custom_rules` object](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-job) in the create anomaly detection jobs API.