﻿---
title: Anomaly detection API quick reference
description: All machine learning anomaly detection endpoints have the following base: The main resources can be accessed with a variety of endpoints: /anomaly_detectors/:...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-api-quickref
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Anomaly detection API quick reference
All machine learning anomaly detection endpoints have the following base:
```js
/_ml/
```

The main resources can be accessed with a variety of endpoints:
- [`/anomaly_detectors/`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-close-job): Create and manage anomaly detection jobs
- [`/calendars/`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-calendars-2): Create and manage calendars and scheduled events
- [`/datafeeds/`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-datafeeds): Select data from Elasticsearch to be analyzed
- [`/filters/`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-filters-1): Create and manage filters for custom rules
- [`/results/`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-buckets): Access the results of an anomaly detection job
- [`/model_snapshots/`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-get-model-snapshots): Manage model snapshots

For a full list, see [Machine learning anomaly detection APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ml-anomaly).