﻿---
title: Plan your analysis
description: The machine learning features in Elastic Stack enable you to seek anomalies in your data in many different ways. Using proprietary machine learning algorithms,...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-plan
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Plan your analysis
The machine learning features in Elastic Stack enable you to seek anomalies in your data in many different ways. Using [proprietary machine learning algorithms](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-algorithms), the following circumstances are detected:
- Anomalies related to temporal deviations in values, counts, or frequencies
- Anomalies related to unusual locations in geographic data
- Statistical rarity
- Unusual behaviors for a member of a population

Automated periodicity detection and quick adaptation to changing data ensure that you don’t need to specify algorithms, models, or other data science-related configurations in order to get the benefits of machine learning.
When you are deciding which type of anomaly detection to use, the most important considerations are the data sets that you have available and the type of behavior you want to detect.
If you are uncertain where to begin, Kibana can recognize certain types of data and suggest useful anomaly detection jobs. Likewise, some Elastic Agent integrations include anomaly detection job configuration information, dashboards, searches, and visualizations that are customized to help you analyze your data.
For the full list of functions that you can use in your anomaly detection jobs, see [*Function reference*](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-functions). For a list of the preconfigured jobs, see [Supplied configurations](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ootb-ml-jobs).