﻿---
title: Mapping anomalies by location
description: If your data includes vector layers that are defined in the Elastic Maps Service (EMS), your anomaly detection jobs can generate a map of the anomalies...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/mapping-anomalies
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Mapping anomalies by location
If your data includes vector layers that are defined in the [Elastic Maps Service (EMS)](https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-connect-to-ems), your anomaly detection jobs can generate a map of the anomalies by location.

## Prerequisites

If you want to view choropleth maps in **Data Visualizer** or anomaly detection job results, you must have fields that contain valid vector layers (such as [country codes](https://maps.elastic.co/#file/world_countries) or [postal codes](https://maps.elastic.co/#file/usa_zip_codes)).
This example uses the sample web logs data set. For more information, see [Add the sample data](/docs/explore-analyze#gs-get-data-into-kibana).

## Explore your data

If you have fields that contain valid vector layers, you can use the **Data Visualizer** in the **Machine Learning** app to see a choropleth map, in which each area is colored based on its document count. For example:
![A screenshot of a field that contains vector layer values in Data Visualizer](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-data-visualizer-choropleth.png)


## Create an anomaly detection job

To create an anomaly detection job, navigate to the **Anomaly Detection Jobs** page in the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Then click **Create job** and select the appropriate job wizard. Alternatively, use the [create anomaly detection jobs API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-job).
For example, use the multi-metric job wizard to create a job that analyzes the sample web logs data set to detect anomalous behavior in the sum of the data transferred (`bytes` values) for each destination country (`geo.dest` values):
![A screenshot of creating an anomaly detection job using the web logs data in Kibana](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-multimetric-wizard-vector.png)

<dropdown title="API example">
  ```json

  {
    "analysis_config" : {
      "bucket_span":"15m",
      "detectors": [
        {
          "detector_description": "Sum of bytes",
          "function": "sum",
          "field_name": "bytes",
          "partition_field_name": "geo.dest"
        }
      ],
      "influencers": [
      "geo.src",
      "agent.keyword",
      "geo.dest"
      ]
    },
    "data_description" : {
      "time_field": "timestamp"
    },
    "datafeed_config": { <2>
      "datafeed_id": "datafeed-weblogs-vectors",
      "indices": ["kibana_sample_data_logs"],
      "query": {
        "bool": {
          "must": [
            {
              "match_all": {}
            }
          ]
        }
      }
    }
  }




  {
    "end": "2021-07-15T22:00:00Z"
  }
  ```
</dropdown>


## Analyze the results

After the anomaly detection jobs have processed some data, you can view the results in Kibana.
<tip>
  If you used APIs to create the jobs and datafeeds, you cannot see them in Kibana until you follow the prompts to synchronize the necessary saved objects.
</tip>

![A screenshot of the anomaly count by location in Anomaly Explorer](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-anomaly-explorer-vectors.png)

The **Anomaly Explorer** contains a map, which is affected by your swim lane selections. It colors each location to reflect the number of anomalies in that selected time period. Locations that have few anomalies are indicated in blue; locations with many anomalies are red. Thus you can quickly see the locations that are generating the most anomalies. If your vector layers define regions, counties, or postal codes, you can zoom in for fine details.

## What’s next

- [Learn more about **Maps**](https://www.elastic.co/docs/explore-analyze/visualize/maps)
- [Generate alerts for your anomaly detection jobs](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-alerts)