﻿---
title: Detecting anomalous locations in geographic data
description: If your data includes geographic fields, you can use machine learning features to detect anomalous behavior, such as a credit card transaction that occurs...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/geographic-anomalies
products:
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Detecting anomalous locations in geographic data
If your data includes geographic fields, you can use machine learning features to detect anomalous behavior, such as a credit card transaction that occurs in an unusual location or a web request that has an unusual source location.

## Prerequisites

To run this type of anomaly detection job, you must have [machine learning features set up](https://www.elastic.co/docs/explore-analyze/machine-learning/setting-up-machine-learning). You must also have time series data that contains spatial data types. In particular, you must have:
- two comma-separated numbers of the form `latitude,longitude`,
- a [`geo_point`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) field,
- a [`geo_shape`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape) field that contains point values, or
- a [`geo_centroid`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-geocentroid-aggregation) aggregation

The latitude and longitude must be in the range -180 to 180 and represent a point on the surface of the Earth.
This example uses the sample eCommerce orders and sample web logs data sets. For more information, see [Add the sample data](/docs/explore-analyze#gs-get-data-into-kibana).

## Explore your geographic data

To get the best results from machine learning analytics, you must understand your data. You can use the **Data Visualizer** in the **Machine Learning** app for this purpose. Search for specific fields or field types, such as geo-point fields in the sample data sets. You can see how many documents contain those fields within a specific time period and sample size. You can also see the number of distinct values, a list of example values, and preview them on a map. For example:
![A screenshot of a geo_point field in Data Visualizer](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-data-visualizer-geopoint.jpg)


## Create an anomaly detection job

There are a few limitations to consider before you create this type of job:
1. You cannot create forecasts for anomaly detection jobs that contain geographic functions.
2. You cannot add [custom rules with conditions](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-rules) to detectors that use geographic functions.

If those limitations are acceptable, try creating an anomaly detection job that uses the [`lat_long` function](/docs/reference/machine-learning/ml-geo-functions#ml-lat-long) to analyze your own data or the sample data sets.
To create an anomaly detection job that uses the `lat_long` function, navigate to the **Anomaly Detection Jobs** page in the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Then click **Create job** and select the appropriate job wizard. Alternatively, use the [create anomaly detection jobs API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-put-job).
For example, create a job that analyzes the sample eCommerce orders data set to find orders with unusual coordinates (`geoip.location` values) relative to the past behavior of each customer (`user` ID):
![A screenshot of creating an anomaly detection job using the eCommerce data in Kibana](https://www.elastic.co/docs/explore-analyze/images/machine-learning-ecommerce-advanced-wizard-geopoint.jpg)

<dropdown title="API example">
  ```json

  {
    "analysis_config" : {
      "bucket_span":"15m",
      "detectors": [
        {
          "detector_description": "Unusual coordinates by user",
          "function": "lat_long",
          "field_name": "geoip.location",
          "by_field_name": "user"
        }
      ],
      "influencers": [
        "geoip.country_iso_code",
        "day_of_week",
        "category.keyword"
        ]
    },
    "data_description" : {
      "time_field": "order_date"
    },
    "datafeed_config":{ <2>
      "datafeed_id": "datafeed-ecommerce-geo",
      "indices": ["kibana_sample_data_ecommerce"],
      "query": {
        "bool": {
          "must": [
            {
              "match_all": {}
            }
          ]
        }
      }
    }
  }




  {
    "end": "2022-03-22T23:00:00Z"
  }
  ```
</dropdown>

Alternatively, create a job that analyzes the sample web logs data set to detect events with unusual coordinates (`geo.coordinates` values) or unusually high sums of transferred data (`bytes` values):
![A screenshot of creating an anomaly detection job using the web logs data in Kibana](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-advanced-wizard-geopoint.jpg)

<dropdown title="API example">
  ```json

  {
    "analysis_config" : {
      "bucket_span":"15m",
      "detectors": [
        {
          "detector_description": "Unusual coordinates",
          "function": "lat_long",
          "field_name": "geo.coordinates"
        },
        {
          "function": "high_sum",
          "field_name": "bytes"
        }
      ],
      "influencers": [
        "geo.src",
        "extension.keyword",
        "geo.dest"
      ]
    },
    "data_description" : {
      "time_field": "timestamp",
       "time_format": "epoch_ms"
    },
    "datafeed_config":{ <2>
      "datafeed_id": "datafeed-weblogs-geo",
      "indices": ["kibana_sample_data_logs"],
      "query": {
        "bool": {
          "must": [
            {
              "match_all": {}
            }
          ]
        }
      }
    }
  }




  {
    "end": "2022-04-15T22:00:00Z"
  }
  ```
</dropdown>


## Analyze the results

After the anomaly detection jobs have processed some data, you can view the results in Kibana.
<tip>
  If you used APIs to create the jobs and datafeeds, you cannot see them in Kibana until you follow the prompts to synchronize the necessary saved objects.
</tip>

When you select a period that contains an anomaly in the **Anomaly Explorer** swim lane results, you can see a map of the typical and actual coordinates. For example, in the eCommerce sample data there is a user with anomalous shopping behavior:
![A screenshot of an anomalous event in the eCommerce data in Anomaly Explorer](https://www.elastic.co/docs/explore-analyze/images/machine-learning-ecommerce-anomaly-explorer-geopoint.jpg)

A "typical" value indicates a centroid of a cluster of previously observed locations that is closest to the "actual" location at that time. For example, there may be one centroid near the user’s home and another near the user’s work place since there are many records associated with these distinct locations.
Likewise, there are time periods in the web logs sample data where there are both unusually high sums of data transferred and unusual geographical coordinates:
![A screenshot of an anomalous event in the web logs data in Anomaly Explorer](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-anomaly-explorer-geopoint.jpg)

You can use the top influencer values to further filter your results and identify possible contributing factors or patterns of behavior.
You can also view the anomaly in **Maps** by clicking **View in Maps** in the action menu in the anomaly table.
![A screenshot of the anomaly table with the Action menu opened and the "View in Maps" option selected](https://www.elastic.co/docs/explore-analyze/images/machine-learning-view-in-maps.jpg)

When you try this type of anomaly detection job with your own data, it might take some experimentation to find the best combination of buckets, detectors, and influencers to detect the type of behavior you’re seeking.
For more information about anomaly detection concepts, see [Concepts](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection). For the full list of functions that you can use in anomaly detection jobs, see [*Function reference*](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-functions). For more anomaly detection examples, see [Examples](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/anomaly-how-tos).

## Add anomaly layers to your maps

To integrate the results from your anomaly detection job in **Maps**, click **Add layer**, then select **ML Anomalies**. You must then select or create an anomaly detection job that uses the `lat_long` function.
For example, you can extend the map example from [Build a map to compare metrics by country or region](https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-getting-started) to include a layer that uses your web logs anomaly detection job:
![A screenshot of an anomaly within the Maps app](https://www.elastic.co/docs/explore-analyze/images/machine-learning-weblogs-anomaly-map.jpg)


## What’s next

- [Learn more about **Maps**](https://www.elastic.co/docs/explore-analyze/visualize/maps)
- [Generate alerts for your anomaly detection jobs](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-alerts)