﻿---
title: How-tos
description: Though it is quite simple to analyze your data and provide quick machine learning results, gaining deep insights might require some additional planning...
url: https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/anomaly-how-tos
products:
  - Elastic Cloud Serverless
  - Elasticsearch
  - Machine Learning
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# How-tos
Though it is quite simple to analyze your data and provide quick machine learning results, gaining deep insights might require some additional planning and configuration. The guides in this section describe some best practices for generating useful machine learning results and insights from your data.
- [Generating alerts for anomaly detection jobs](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-alerts)
- [Aggregating data for faster performance](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-aggregation)
- [Using runtime fields in datafeeds](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-transform)
- [Customizing detectors with custom rules](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-detector-custom-rules)
- [Detecting anomalous categories of data](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-categories)
- [Performing population analysis](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-populations)
- [Reverting to a model snapshot](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-reverting-model-snapshot)
- [Detecting anomalous locations in geographic data](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/geographic-anomalies)
- [Mapping anomalies by location](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/mapping-anomalies)
- [Adding custom URLs to machine learning results](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-configuring-url)
- [Anomaly detection jobs from visualizations](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-jobs-from-lens)
- [Exporting and importing machine learning jobs](/docs/explore-analyze/machine-learning/setting-up-machine-learning#move-jobs)


## Anomaly detection examples in blog posts

The blog posts listed below show how to get the most out of Elastic machine learning anomaly detection.
- [Sizing for machine learning with Elasticsearch](https://www.elastic.co/blog/sizing-machine-learning-with-elasticsearch)
- [Filtering input data to refine machine learning jobs](https://www.elastic.co/blog/filtering-input-data-to-refine-machine-learning-jobs)
- [Temporal vs. population analysis in Elastic machine learning](https://www.elastic.co/blog/temporal-vs-population-analysis-in-elastic-machine-learning)
- [Using Elasticsearch and machine learning for IT Operations](https://www.elastic.co/blog/using-elasticsearch-and-machine-learning-for-it-operations)
- [Using machine learning and Elasticsearch for security analytics](https://www.elastic.co/blog/using-machine-learning-and-elasticsearch-for-security-analytics-deep-dive)
- [User annotations for Elastic machine learning](https://www.elastic.co/blog/augmenting-results-with-user-annotations-for-elastic-machine-learning)
- [Custom Elasticsearch aggregations for machine learning jobs](https://www.elastic.co/blog/custom-elasticsearch-aggregations-for-machine-learning-jobs)
- [Analysing Linux auditd anomalies with Auditbeat and machine learning](https://www.elastic.co/blog/analysing-linux-auditd-anomalies-with-auditbeat-and-elastic-stack-machine-learning)
- [How to optimize Elasticsearch machine learning job configurations using job validation](https://www.elastic.co/blog/how-to-optimize-elasticsearch-machine-learning-job-configurations-using-job-validation)
- [Interpretability in machine learning: Identifying anomalies, influencers, and root causes](https://www.elastic.co/blog/interpretability-in-ml-identifying-anomalies-influencers-root-causes)

There are also some examples in the machine learning folder in the [examples repository](https://github.com/elastic/examples).