﻿---
title: Tags
description: Use tags to categorize your saved objects, then filter for related objects based on shared tags. To get started, go to the Tags management page using...
url: https://www.elastic.co/docs/explore-analyze/find-and-organize/tags
products:
  - Elastic Cloud Serverless
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Tags
Use tags to categorize your saved objects, then filter for related objects based on shared tags.
To get started, go to the **Tags** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
![Tags management](https://www.elastic.co/docs/explore-analyze/images/kibana-tag-management-section.png)


## Permissions

To create tags, you must meet the minimum requirements.
- Access to **Tags** requires a role with the the `Tag Management` Kibana privilege.
- The `read` privilege allows to assign tags to the saved objects for which you have write permission.
- The `write` privilege allows to create, edit, and delete tags.

<note>
  Having the `Tag Management` Kibana privilege is not required to view tags assigned on objects you have `read` access to, or to filter objects by tags from the global search.
</note>


## Create a tag

Create a tag to assign to your saved objects.
1. Click **Create tag**.
2. Enter a name and select a color for the new tag.
   The name cannot be longer than 50 characters.
3. Click **Create tag**.


## Assign a tag to an object

To assign and remove tags, you must have `write` permission on the objects to which you assign the tags.
1. Find the tag you want to assign.
2. Click the actions icon ![Actions icon](https://www.elastic.co/docs/explore-analyze/images/kibana-actions_icon.png), and then select **Manage assignments**.
3. Select the objects to which you want to assign or remove tags.
   ![Assign flyout](https://www.elastic.co/docs/explore-analyze/images/kibana-manage-assignments-flyout.png)
4. Click **Save tag assignments**.


## Delete a tag

When you delete a tag, you remove it from all saved objects that use it.
1. Click the actions icon ![Actions icon](https://www.elastic.co/docs/explore-analyze/images/kibana-actions_icon.png), and then select **Delete**.
2. Click **Delete tag**.

<tip>
  To assign, delete, or clear multiple tags, select them in the **Tags** view, and then select the action from the **selected tags** menu.
</tip>