﻿---
title: Find apps and objects
description: To quickly find apps and the objects you create, use the search field in the global header. Search suggestions include deep links into applications, allowing...
url: https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Find apps and objects
To quickly find apps and the objects you create, use the search field in the global header. Search suggestions include deep links into applications, allowing you to directly navigate to the views you need most.
![Example of searching for apps](https://www.elastic.co/docs/explore-analyze/images/kibana-app-navigation-search.png)

You can search for objects by type, name, and tag. To get the most from the search feature, follow these tips:
- Use the keyboard shortcut—**Ctrl**+**/** on Windows and Linux, **Command**+**/** on MacOS—to focus on the input at any time.
- Use the provided syntax keywords.
  |                         |                                                                                                                                                |
  |-------------------------|------------------------------------------------------------------------------------------------------------------------------------------------|
  | Search by type          | `type:dashboard`Available types: `application`, `canvas-workpad`, `dashboard`, `data-view`, `lens`, `maps`, `query`, `search`, `visualization` |
  | Search by tag           | `tag:mytagname``tag:"tag name with spaces"`                                                                                                    |
  | Search by type and name | `type:dashboard my_dashboard_title`                                                                                                            |
  | Advanced searches       | `tag:(tagname1 or tagname2) my_dashboard_title``type:lens tag:(tagname1 or tagname2)``type:(dashboard or canvas-workpad) logs`                 |

This example searches for visualizations with the tag `design` .
![Example of searching for tags](https://www.elastic.co/docs/explore-analyze/images/kibana-tags-search.png)