﻿---
title: Using ML-nodes or Elastic Inference Service (EIS)
description: The Elastic Inference Service (EIS) requires zero setup or management. It's always-on, has excellent ingest throughput, and uses simple token-based billing...
url: https://www.elastic.co/docs/explore-analyze/elastic-inference/ml-node-vs-eis
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
  - Self-managed Elastic deployments: Unavailable
---

# Using ML-nodes or Elastic Inference Service (EIS)
## When to use EIS?

The Elastic Inference Service (EIS) requires zero setup or management. It's always-on, has excellent ingest throughput, and uses simple token-based billing.
Use EIS if you're getting started with [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search) or [hybrid search](https://www.elastic.co/docs/solutions/search/hybrid-search) and want a smooth experience. Under the hood, EIS uses GPUs for ML inference, which are more efficient and allow a faster, more cost-effective experience for most usecases.

## When to use machine learning nodes?

ML nodes are a more configurable solution than EIS where you can set up specific nodes using CPUs to execute [ML inference](https://www.elastic.co/docs/explore-analyze/elastic-inference/inference-api). Machine learning nodes tend to give more fine-grained control.
Use ML nodes if you want to decide how your models run, you want to run custom models, or you have a self-managed setup.

## How do I switch from using ML nodes to EIS on an existing index?

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

```json

{
  "properties": {
    "text": {
      "type": "semantic_text",
      "inference_id": ".elser-2-elastic"
    }
  }
}
```

You can also switch an EIS-based index to use ML nodes:
```json

{
  "properties": {
    "text": {
      "type": "semantic_text",
      "inference_id": ".elser-2-elasticsearch"
    }
  }
}
```