﻿---
title: Elastic Inference Service for self-managed clusters
description: Use Elastic Inference Service (EIS) with your self-managed, ECE, and ECK clusters through Cloud Connect.
url: https://www.elastic.co/docs/explore-analyze/elastic-inference/connect-self-managed-cluster-to-eis
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud on Kubernetes
  - Elastic Stack
applies_to:
  - Elastic Stack: Generally available since 9.3
---

# Elastic Inference Service for self-managed clusters
[Elastic Inference Service (EIS)](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis) is available with zero setup on Elastic Cloud Hosted and Serverless deployments. To use EIS with other deployment types, you can use [Cloud Connect](https://www.elastic.co/docs/deploy-manage/cloud-connect). Cloud Connect enables you to use Elastic Cloud services in your self-managed cluster without having to install and maintain their infrastructure yourself.
You can use EIS to enable features such as:
- [Semantic search](https://www.elastic.co/docs/solutions/search/semantic-search)
- [AI Assistants](https://www.elastic.co/docs/explore-analyze/ai-features/ai-chat-experiences/ai-assistant)
- [Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder)
- [Attack Discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery)

For a full list of EIS-powered features, refer to [AI features powered by EIS](/docs/explore-analyze/elastic-inference/eis#ai-features-powered-by-eis).

## Prerequisites

Before you can use EIS with your self-managed cluster, ensure you meet the following requirements:
- Your self-managed cluster is on an [Enterprise self-managed license](https://www.elastic.co/subscriptions) or an [active self-managed trial license](https://cloud.elastic.co/registration)
- You have an Elastic Cloud account with either an [active Cloud Trial](https://cloud.elastic.co/registration) or [billing information configured](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/add-billing-details)


## Set up EIS with Cloud Connect

<stepper>
  <step title="Open Cloud Connect">
    In your self-managed Kibana instance, navigate to the **Cloud Connect** page using the [search bar](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    ![Screenshot showing Cloud Connect page](https://www.elastic.co/docs/explore-analyze/images/cloud-connect-eis.png)
  </step>

  <step title="Get your Cloud Connect API key">
    Sign up or log in to Elastic Cloud and get the Cloud Connect API key:
    - If you don’t have an account yet, click **Sign up** and follow the prompts to create your account and start a free Cloud Trial.
    - If you already have an Elastic Cloud account, click **Log in**.
  </step>

  <step title="Connect your cluster">
    Copy the Cloud Connect API key, paste it into your self-managed cluster's Cloud Connect page, then click **Connect**.
  </step>

  <step title="Enable Elastic Inference Service">
    On the **Cloud connected services** page, click **Connect** for Elastic Inference Service.
    ![Screenshot showing Cloud Connect and EIS](https://www.elastic.co/docs/explore-analyze/images/eis-cloud-connect-connect-ui.png)
  </step>
</stepper>

After you connect Elastic Inference Service through Cloud Connect, Elasticsearch automatically creates multiple inference endpoints for search and chat use cases, along with corresponding Kibana AI connectors. Supported Kibana features now use these connectors automatically.

## Test EIS through Cloud Connect with semantic search

In this example, you create an index with a `semantic_text` field, index a document, then run a query that returns a semantically related match.
In **Dev Tools**, run the following requests:
<stepper>
  <step title="Create an index with a `semantic_text` field">
    ```json

    {
      "mappings": {
        "properties": {
          "text": {
            "type": "semantic_text" <1>
          }
        }
      }
    }
    ```
  </step>

  <step title="Index a document">
    ```json

    {
      "text": "Aberdeen Football Club"
    }
    ```
  </step>

  <step title="Run a search query">
    ```json

    {
      "query": {
        "match": {
          "text": "soccer"
        }
      }
    }
    ```
  </step>
</stepper>

The response should include the indexed document:
```json
{
  "took": 161,
  "timed_out": false,
  "_shards": {
    "total": 1,
    "successful": 1,
    "skipped": 0,
    "failed": 0
  },
  "hits": {
    "total": {
      "value": 1,
      "relation": "eq"
    },
    "max_score": 4.729913,
    "hits": [
      {
        "_index": "semantic-search-eis",
        "_id": "oyH935sBG2FaZ-zOMrer",
        "_score": 4.729913,
        "_source": {
          "text": "Aberdeen Football Club"
        }
      }
    ]
  }
}
```


## Regions and billing

For information about EIS regions and request routing, refer to [Region and hosting](/docs/explore-analyze/elastic-inference/eis#eis-regions).
EIS is billed per million tokens and consumes ECUs. For details on pricing and usage tracking, refer to [Pricing](/docs/explore-analyze/elastic-inference/eis#pricing) and [Monitor your token usage](/docs/explore-analyze/elastic-inference/eis#monitor-your-token-usage).