﻿---
title: Customize the Discover view
description: Customize the Discover view with flexible display options for the document table, chart, and sidebar. Adjust columns, density, row height, and field visibility for optimal exploration.
url: https://www.elastic.co/docs/explore-analyze/discover/document-explorer
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Customize the Discover view
**Discover** offers flexible customization options to optimize your data exploration experience. Adjust the document table layout, modify column arrangements, control chart and sidebar visibility, and configure display density to focus on the data that matters most. These customizations persist across sessions and help you work more efficiently with your Elasticsearch data.
<tip>
  Discover provides default [context-aware experiences](/docs/explore-analyze/discover/discover-get-started#context-aware-discover) tailored to the type of data that you're exploring, and you can further customize your Discover view on top of them.
</tip>

![A view of the Discover app](https://www.elastic.co/docs/explore-analyze/images/kibana-hello-field.png)


## Hide or resize areas

- You can hide and show the chart and the fields list using the available collapse and expand button in the corresponding area.
- Adjust the width and height of each area by dragging their border to the size you want. The size of each area is saved in your browser for the next time you open **Discover**.


## Modify the document table

Customize the appearance of the document table and its contents to your liking.
![Options to customize the table in Discover](https://www.elastic.co/docs/explore-analyze/images/kibana-discover-customize-table.png)

### Reorder and resize the columns

- To move a single column, drag its header and drop it to the position you want. You can also open the column’s contextual options, and select **Move left** or **Move right** in the available options.
- To move multiple columns, click **Columns**. In the pop-up, drag the column names to their new order.
- To resize a column, drag the right edge of the column header until the column is the width that you want.
  <tip>
  Column widths are stored with a Discover session. When you add a Discover session as a dashboard panel, it appears the same as in **Discover**.
  </tip>


### Customize the table density

You can adjust the density of the table from the **Display options** located in the table toolbar. This can be particularly useful when scrolling through many results.

### Adjust the row height

To set the row height to one or more lines, or automatically adjust the height to fit the contents, open the **Display options** in the table toolbar, and adjust it as you need.
You can define different settings for the header row and body rows.

### Limit the sample size

When the number of results returned by your search query (displayed at the top of the **Documents** or **Results** tab) is greater than the value of [`discover:sampleSize`](https://www.elastic.co/docs/reference/kibana/advanced-settings#kibana-discover-settings), the number of results displayed in the table is limited to the configured value by default. You can adjust the initial sample size for searches to any number between 10 and `discover:sampleSize` from the **Display options** located in the table toolbar.
![Limit sample size in Discover](https://www.elastic.co/docs/explore-analyze/images/kibana-discover-limit-sample-size.png "title")
On the last page of the table, a message indicates that you’ve reached the end of the loaded search results. From that message, you can choose to load more results to continue exploring.

### Sort the fields

Sort the data by one or more fields, in ascending or descending order. The default sort is based on the time field, from new to old.
To add or remove a sort on a single field, click the column header, and then select the sort order.
To sort by multiple fields:
1. Click the **Sort fields** option.
   ![Pop-up in document table for sorting columns](https://www.elastic.co/docs/explore-analyze/images/kibana-document-explorer-sort-data.png "title")
2. To add fields to the sort, select their names from the dropdown menu.
   By default, columns are sorted in the order they are added.
   ![Multi field sort in the document table](https://www.elastic.co/docs/explore-analyze/images/kibana-document-explorer-multi-field.png)
3. To change the sort order, select a field in the pop-up, and then drag it to the new location.


### Edit a field

Change how Kibana displays a field.
1. Click the column header for the field, and then select **Edit data view field.**
2. In the **Edit field** form, change the field name and format.
   For detailed information on formatting options, refer to [Format data fields](/docs/explore-analyze/find-and-organize/data-views#managing-fields).


### Filter the documents

Narrow your results to a subset of documents so you're comparing the data of interest.
1. Select the documents you want to compare.
2. Click the **Selected** option, and then select **Show selected documents only**.
   ![Compare data in the document table](https://www.elastic.co/docs/explore-analyze/images/kibana-document-explorer-compare-data.png)

You can also compare individual field values using the [**Compare selected** option](/docs/explore-analyze/discover/discover-get-started#compare-documents-in-discover).

### Set the number of results per page

To change the numbers of results you want to display on each page, use the **Rows per page** menu. The default is 100 results per page.
![Menu with options for setting the number of results in the document table](https://www.elastic.co/docs/explore-analyze/images/kibana-document-table-rows-per-page.png)