﻿---
title: Discover
description: Use Discover to search and filter documents, analyze field structures, visualize patterns, and save findings to reuse later or share with dashboards.
url: https://www.elastic.co/docs/explore-analyze/discover
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Discover
**Discover** is the primary tool for exploring your Elasticsearch data in Kibana. Search and filter documents, analyze field structures, visualize patterns, and save findings to reuse later or share with dashboards. Whether investigating issues, analyzing trends, or validating data quality, **Discover** offers a flexible interface for understanding your data.
![A view of the Discover app](https://www.elastic.co/docs/explore-analyze/images/kibana-hello-field.png)


## What you can do with Discover

**Search and explore**
: Search through your data using KQL, Lucene, or ES|QL. Filter results to focus on what matters. Discover adapts its interface based on the type of data you're exploring, providing specialized experiences for logs, metrics, and other data types.
**Analyze fields and documents**
: View field statistics, examine individual documents, compare multiple documents side by side, and find patterns in your log data.
**Visualize on the fly**
: Create quick visualizations from aggregatable fields, or use ES|QL to build charts directly from your queries.
**Save and share**
: Save your Discover sessions to reuse later, add them to dashboards, or share them with your team. You can also generate reports and create alerts based on your searches.

## Get started

New to Discover? Start with these resources:
- **[Get started with Discover](https://www.elastic.co/docs/explore-analyze/discover/discover-get-started)** - A hands-on tutorial that walks you through exploring data, from loading data to filtering and visualizing your findings.
- **[Using ES|QL](https://www.elastic.co/docs/explore-analyze/discover/try-esql)** - Learn how to use the Elasticsearch Query Language for powerful data exploration.


## Common tasks

Once you're familiar with the basics, explore these guides for specific tasks:
- **[Search and filter data](https://www.elastic.co/docs/explore-analyze/discover/discover-get-started)** - Build queries and apply filters to narrow down your results.
- **[Customize the Discover view](https://www.elastic.co/docs/explore-analyze/discover/document-explorer)** - Adjust the layout, columns, and display options to suit your needs.
- **[Save a search for reuse](https://www.elastic.co/docs/explore-analyze/discover/save-open-search)** - Save your Discover sessions and add them to dashboards.


## Advanced features

The following guides cover additional features you can use in Discover:
- [Add runtime fields to your data view](/docs/explore-analyze/discover/discover-get-started#add-field-in-discover)
- [Run queries in the background](https://www.elastic.co/docs/explore-analyze/discover/background-search)
- [Analyze field statistics and patterns](https://www.elastic.co/docs/explore-analyze/discover/run-pattern-analysis-discover)
- [Search for relevance](https://www.elastic.co/docs/explore-analyze/discover/discover-search-for-relevance)