﻿---
title: Exploring dashboards
description: Learn how to explore and interact with Kibana dashboards using filters, time ranges, and controls to uncover insights in your data.
url: https://www.elastic.co/docs/explore-analyze/dashboards/using
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Exploring dashboards
Kibana dashboards support filtering, time range adjustments, and interactive controls that let you focus on specific data segments or time periods. Use these interactive features to drill into your data, compare metrics across different dimensions, and uncover insights that matter to your analysis.
This page covers the main ways to explore dashboard data: using Kibana Query Language (KQL) queries, filter pills, time ranges, and dashboard controls. You'll also learn how to view underlying data and switch between different display modes.

## Search and filter your dashboard data

Kibana supports several ways to explore the data displayed in a dashboard more in depth:
- The **query bar**, using KQL expressions by default.
- The **time range**, that allows you to display data only for the period that you want to focus on. You can set a global time range for the entire dashboard, or specify a custom time range for each panel.
- **Controls**, that dashboard creators can add to help viewers filter on specific values.
- **Filter pills**, that you can add and combine by clicking on specific parts of the dashboard visualizations, or by defining conditions manually from the filter editor. The filter editor is a good alternative if you’re not comfortable with using KQL expressions in the main query bar.
- View the data of a panel and the requests used to build it.

This section shows the most common ways for you to filter dashboard data. For more information about Kibana and Elasticsearch filtering capabilities, refer to [Querying and filtering](https://www.elastic.co/docs/explore-analyze/query-filter).

### Filter dashboards using the KQL query bar

The query bar lets you build filters using [Kibana Query Language (KQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql). When typing, it dynamically suggests matching fields, operators, and values to help you get the exact results that you want.
You can use KQL to create complex queries that filter your dashboard data. For example:
- `status:error` to show only error records
- `response_time > 1000` to display requests slower than 1 second
- `user.name:"john doe" AND status:active` to combine multiple conditions

<tip applies-to="Elastic Cloud Serverless: Unavailable, Elastic Stack: Preview since 9.2">
  When working with large datasets, complex KQL queries might cause dashboards to load slowly. In versions 9.2 and later, you can [send long-running searches to the background](https://www.elastic.co/docs/explore-analyze/discover/background-search) and continue working on other tasks while the data loads.
</tip>


### Use filter pills

Use filter pills to focus in on the specific data you want.
![Filter pills](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_filter_pills_8.15.0.png)


#### Add pills by interacting with visualizations

You can interact with some panel visualizations to explore specific data more in depth. Upon clicking, filter pills are added and applied to the entire dashboard, so that surrounding panels and visualizations also reflect your browsing.
![Browsing a chart creates a filter dynamically](https://www.elastic.co/docs/explore-analyze/images/add-filter-pills-8.17.gif)


#### Add pills using the filter editor

As an alternative to the main query bar, you can filter dashboard data by defining individual conditions on specific fields and values, and by combining these conditions together in a filter pill.
![Filter editor with 2 conditions](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard-filter-editor.png)


#### Filter pill actions

You can interact with filter pills to edit them, temporarily alter their behavior without having to remove them, or make them available in other contexts. The following options are available when selecting a filter pill:
<definitions>
  <definition term="Pin across all apps and Unpin">
    Adds this filter to available dashboards and to apps such as **Discover**, **Lens**, **Maps**, and **Visualize**. You remove the filter if you:
    - Unpin it. In this case, the filter only remains on the currently open app, unpinned.
    - Remove it from any place while it's still pinned.
    - Refresh your session, for example by opening a dashboard in a new tab. Pinned filters are not saved along with the dashboard, visualization, or Discover session that you added them to.
    <tip>
      When a pinned filter can't be applied, for example if a field specified in the filter doesn't exist in the current data view, the filter is ignored and shows in a different color.
    </tip>
  </definition>
  <definition term="Edit filter">
    Lets you edit and update the filter.
  </definition>
  <definition term="Exclude results and Include results">
    Reverses the filter behavior.
  </definition>
  <definition term="Temporarily disable and Re-enable">
    Lets you temporarily deactivate a filter instead of requiring you to remove it. This is particularly useful for testing different filter combinations.
  </definition>
  <definition term="Delete">
    Removes the filter.
  </definition>
</definitions>

You can perform most of these actions at once for all filters in your current view using the **Filter** icon `filter`. From the menu that opens, select **Apply to all**, then choose the action you'd like to perform.

### Filter dashboards using the KQL query bar

The query bar lets you build filters using [Kibana Query Language (KQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql). When typing, it dynamically suggests matching fields, operators, and values to help you get the exact results that you want.
![KQL filter dynamically suggesting values](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard-filter-kql.png)


### Set a time range

The data visible in a dashboard highly depends on the time range that is applied. In a dashboard, you can select a time range that applies globally to all panels, or set a custom time range for specific panels.

#### Apply a global time range to an entire dashboard

The global time range menu is located right next to the query bar, in the dashboard’s header. With this menu, you can select the time range to apply, and set the frequency for refreshing the dashboard data. Setting the time range is a common action in Kibana. Refer to [Set the time range](https://www.elastic.co/docs/explore-analyze/query-filter/filtering) for more details.
![Time range menu with multiple time range suggestions](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard-global-time-range.png)


#### Apply a custom time range to a panel

**To apply a panel-level time range:**
1. Hover over the panel and click ![Settings icon](https://www.elastic.co/docs/explore-analyze/images/kibana-settings-icon-hover-action.png "kibana-settings-icon-hover-action"). The **Settings** flyout appears.
2. Turn on **Apply a custom time range**.
3. Enter the time range you want to view, then click **Apply**.

**To view and edit the time range applied to a specific panel:**
When a custom time range is active for a single panel, it is indicated in the panel’s header.
To edit it, click the filter. You can then adjust and apply the updated **Time range**.

### Use available controls

Dashboard authors can [add various types of additional controls](https://www.elastic.co/docs/explore-analyze/dashboards/add-controls) to help you filter the data that you want to visualize.

#### Filter the data with Options list controls

Filter the data with one or more options that you select.
1. Open the Options list dropdown.
2. Select the available options.
   Selecting *Exists* returns all documents that contain an indexed value for the field.
3. Select how to filter the options.
   - To display only the data for the options you selected, select **Include**.
- To exclude the data for the options you selected, select **Exclude**.
4. To clear the selections, click ![The icon to clear all selected options in the Options list](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_controlsClearSelections_8.3.0.png).
5. To display only the options you selected in the dropdown, click ![The icon to display only the options you have selected in the Options list](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_showOnlySelectedOptions_8.3.0.png).

![Options list control](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_controlsOptionsList.png)


#### Filter the data with Range slider controls

Filter the data within a specified range of values.
1. On the Range slider, click a value.
2. Move the sliders to specify the values you want to display.
   The dashboard displays only the data for the range of values you specified.
3. To clear the specified values, click ![The icon to clear all specified values in the Range slider](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_controlsClearSelections_8.3.0.png).

![Range slider control](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_controlsRangeSlider_8.3.0.png)


#### Filter the data with time slider controls

Filter the data within a specified range of time.
1. To view a different time range, click the time slider, then move the sliders to specify the time range you want to display.
2. To advance the time range forward, click ![The icon to advance the time range forward](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_timeSliderControl_advanceForward_8.5.0.png).
3. To advance the time range backward, click ![The icon to advance the time range backward](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_timeSliderControl_advanceBackward_8.5.0.png).
4. To animate the data changes over time, click ![The icon to clear all specified values in the Range slider](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_timeSliderControl_animate_8.5.0.png).
5. To clear the specified values, click ![The icon to clear all specified values in the Range slider](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard_controlsClearSelections_8.3.0.png).

![Time slider control](https://www.elastic.co/docs/explore-analyze/images/dashboard_timeslidercontrol_8.17.0.gif)


### View the panel data and requests

Viewing the details of all requests used to build a visualization and the resulting data helps you confirm that the visualization is showing the right data and that the requests are performing as expected.
The available actions can vary depending on the panel you're inspecting.

#### View and download the data in visualizations

This action is possible for all charts created using **Lens** or ES|QL. It is not available for other types of panels, such as **Maps** or **Vega** visualizations.
1. Open the panel menu and select **Inspect**.
2. Open the **View** dropdown, then select **Data**.
3. If you'd like to download the data, select **Download CSV**, then select the format type from the dropdown:
   - **Formatted CSV**: Contains human-readable dates and numbers.
- **Raw CSV**: Formatted for computer use.
  When you download a visualization panel with multiple layers, each layer produces a CSV file, and the file names contain the visualization and layer data view names.


#### View the requests that collect the data

The request **Inspector** is available in **Discover** and for all **Dashboards** visualization panels that are built from a query. The available information can differ based on the request.
1. Open the **Inspector**:
   - If you're in **Discover**, select **Inspect** from the application's toolbar.
- If you're in **Dashboards**, open the panel menu and select **Inspect**.
2. Open the **View** dropdown, then select **Requests**.
3. Several tabs with different information can appear, depending on nature of the request:
   <tip>
   Some visualizations rely on several requests. From the dropdown, select the request you want to inspect.
   </tip>
   - **Statistics**: Provides general information and statistics about the request. For example, you can check if the number of hits and query time match your expectations. If not, this can indicate an issue with the request used to build the visualization.
- **Clusters and shards**: Lists the Elasticsearch clusters and shards per cluster queried to fetch the data and shows the status of the request on each of them. With the information in this tab, you can check if the request is properly executed, especially in case of cross-cluster search.
  <note>
  This tab is not available for ES|QL queries and Vega visualizations.
  </note>
- **Request**: Provides a full view of the visualization's request, which you can copy or **Open in Console** to refine, if needed.
- **Response**: Provides a full view of the response returned by the request.


#### View the time range on specific panels

When a custom time range is active for a single panel, it is indicated in the panel’s header.
You can view it in more detail and edit it by clicking the filter.

### View and edit the visualization configuration

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

When viewing a dashboard with read-only permissions, certain visualization panels allow you to view how the visualization itself is configured, and to temporarily edit that configuration.
1. Hover over a visualization panel and select **Show visualization configuration**. The **Configuration** flyout appears.
   If this option isn't available, it means one of two things:
   - The visualization panel type doesn't support this option.
- You have **Edit** permissions for this dashboard. In this case, switch the dashboard to **Edit** mode. You will then be able to edit the configuration of the visualization for all viewers of the dashboard.
2. View the configuration of the visualization. You can make edits, but these will be lost as soon as you exit the flyout.
3. Select **Cancel** to exit the **Configuration** flyout.


## Full screen mode and maximized panel views

You can display dashboards in full screen mode to gain visual space and view or show visualizations without the rest of the Kibana interface.
![A dashboard in full screen mode](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard-full-screen.png)

If you need to focus on a particular panel, you can maximize it by opening the panel menu and selecting **Maximize**. You can minimize it again the same way.
<tip>
  When sharing a dashboard with a link while a panel is in maximized view, the generated link will also open the dashboard on the same maximized panel view.
</tip>

![A maximized panel in a dashboard](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard-panel-maximized.png)