﻿---
title: Sharing dashboards
description: Share Kibana dashboards with your team using links, embeds, or by exporting them as NDJSON files for import into other environments.
url: https://www.elastic.co/docs/explore-analyze/dashboards/sharing
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Sharing dashboards
Share your dashboards with team members and stakeholders using shareable links, embeds, or file exports. You can also manage permissions to control who can view or edit a dashboard. Kibana provides multiple sharing options to fit different collaboration needs, from quick URL sharing to exporting complete dashboard configurations for migration between environments.
To share a dashboard with a larger audience, click `share` **Share** in the toolbar.
![](https://www.elastic.co/docs/explore-analyze/images/share-dashboard.png)


## Manage access of other users on your dashboard

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

From the icon `share`, you can set whether other users in the space can edit or view a dashboard you own:
- **Can edit**: Everybody in the space can edit, delete, and fully manage the dashboard.
- **Can view**: Everybody in the space can view the dashboard, but cannot edit or delete it. They can duplicate it. This read-only setting can be changed at any time by the dashboard owner or a Kibana administrator.

By default, the dashboard owner is the dashboard creator. This cannot be changed and is not currently visible in the UI. However, in some cases the creator and owner can be different users. For example, if user A creates a dashboard and user B exports and re-imports it in the same space (overwriting the existing dashboard), the creator becomes user B while user A remains the owner.
<note>
  Kibana administrators always have write access to all dashboards.
</note>


## Share a dashboard

You can share your dashboards in several ways:
- [Share with a direct link](/docs/explore-analyze/report-and-share#share-a-direct-link)
- <applies-to>Elastic Cloud Serverless: Unavailable</applies-to> [Embed a dashboard outside of Kibana](/docs/explore-analyze/report-and-share#embed-code)

For detailed information about the sharing options and time ranges, refer to [Reporting and sharing](https://www.elastic.co/docs/explore-analyze/report-and-share).
<tip>
  When sharing a dashboard with a link while a panel is in maximized view, the generated link will also open the dashboard on the same maximized panel view.
</tip>


## Export dashboards

Export dashboards as NDJSON files to migrate them to other Kibana instances, back them up, or share them with other teams. You can export dashboards from **Stack Management** > **Saved Objects**. To configure and start the export:
1. Select the dashboard that you want, then click **Export**.
2. Enable **Include related objects** if you want that objects associated to the selected dashboard, such as data views and visualizations, also get exported. This option is enabled by default and recommended if you plan to import that dashboard again in a different space or cluster.
3. Select **Export**.

![Option to export a dashboard](https://www.elastic.co/docs/explore-analyze/images/kibana-dashboard-export-saved-object.png)
To automate Kibana, you can export dashboards as NDJSON using the [Export saved objects API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-saved-objects). It is important to export dashboards with all necessary references.