﻿---
title: Edit a dashboard
description: Open and edit an existing Kibana dashboard to modify its panels, settings, and controls.
url: https://www.elastic.co/docs/explore-analyze/dashboards/open-dashboard
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Edit a dashboard
Open an existing dashboard in Kibana to modify its visualizations, add or remove panels, adjust settings, or change filtering controls. When you have the appropriate permissions, dashboards automatically open in **Edit** mode, allowing you to make changes immediately.

## Requirements

To edit a dashboard, you need the **All** privilege for the **Dashboard** feature in Kibana.
<note>
  Managed dashboards created by integrations can't be edited directly, but you can [duplicate](https://www.elastic.co/docs/explore-analyze/dashboards/duplicate-dashboards) them and edit the duplicates.
</note>


## Edit an existing dashboard

1. Open the **Dashboards** page in Kibana.
2. Locate the dashboard you want to edit.
   <tip>
   When looking for a specific dashboard, you can filter them by tag or by creator, or search the list based on their name and description. The creator information is only available for dashboards created on or after version 8.14.
   </tip>
3. Click the dashboard name you want to open.
   The dashboard opens automatically in **Edit** mode if you have the right permissions. You can switch between edit and view modes from the toolbar.
4. Make the changes that you need to the dashboard:
   - Adjust the dashboard’s settings
- [Add, remove, move, or edit panels](/docs/explore-analyze/visualize#panels-editors)
- [Change the available controls](https://www.elastic.co/docs/explore-analyze/dashboards/add-controls)
5. **Save** the dashboard.


## Reset dashboard changes

When editing a dashboard, you can revert any changes you’ve made since the last save using the **Reset** button located next to **Save** in the toolbar.
<note>
  Once changes are saved, you can no longer revert them in one click, and instead have to edit the dashboard manually.
</note>