﻿---
title: Create a dashboard
description: Create a new Kibana dashboard from scratch by adding visualizations, controls, and organizing panels to display your data insights.
url: https://www.elastic.co/docs/explore-analyze/dashboards/create-dashboard
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create a dashboard
Create a new dashboard in Kibana to start visualizing and monitoring your data. Once created, you can add visualizations, configure interactive controls, and organize panels to build a comprehensive view of your data that meets your specific monitoring and analysis needs.

## Requirements

Before creating a dashboard, ensure you have:
- [Data indexed into Elasticsearch](https://www.elastic.co/docs/manage-data/ingest) and at least one [data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views) configured
- **All** privilege for the **Dashboard** feature in Kibana


## Create a new dashboard

1. Open the **Dashboards** page in Kibana.
2. Select **Create dashboard** to start with an empty dashboard.
   When you create a dashboard, you are automatically in edit mode and can make changes to the dashboard.
3. Populate your dashboard with the content that you need. You can:
   - [**Add new visualizations**](/docs/explore-analyze/visualize#panels-editors). Create a chart using [Lens](https://www.elastic.co/docs/explore-analyze/visualize/lens), the default visualization editor in Kibana, or other visualizations such as [Maps](https://www.elastic.co/docs/explore-analyze/visualize/maps).
- [**Add existing content from the library**](https://www.elastic.co/docs/explore-analyze/visualize/visualize-library). Select existing visualizations or Discover sessions that have already been configured and saved to the **Visualize Library**.
- [**Add annotations or navigation panels**](/docs/explore-analyze/visualize#panels-editors). Make your dashboard more informative and easier to read with sections, text, and images.
- [**Add controls**](https://www.elastic.co/docs/explore-analyze/dashboards/add-controls). Define a set of interactive filters (options lists, range or time sliders) that you and future users of this dashboard can use to explore its data.
4. Organize your dashboard by [organizing the various panels](https://www.elastic.co/docs/explore-analyze/dashboards/arrange-panels).
5. Define the main settings of your dashboard from the **Settings** menu located in the toolbar.
   1. A meaningful title, description, and [tags](https://www.elastic.co/docs/explore-analyze/find-and-organize/tags) allow you to find the dashboard quickly later when browsing your list of dashboards or using the Kibana search bar.
2. Additional display options allow you unify the look and feel of the dashboard’s panels:
   - **Store time with dashboard** — Saves the specified time filter.
- **Use margins between panels** — Adds a margin of space between each panel.
- **Show panel titles** — Displays the titles in the panel headers.
- **Sync color palettes across panels** — Applies the same color palette to all panels on the dashboard.
- **Sync cursor across panels** — When you hover your cursor over a time series chart or a heatmap, the cursor on all other related dashboard charts automatically appears.
- **Sync tooltips across panels** — When you hover your cursor over a **Lens** chart, the tooltips on all other related dashboard charts automatically appear.
3. Click **Apply**.
   ![Change and apply dashboard settings](https://images.contentstack.io/v3/assets/bltefdd0b53724fa2ce/blt4a6e9807f1fac9f8/6750ee9cef6d5a250c229e50/dashboard-settings-8.17.0.gif "title")
6. Save the dashboard.
   <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to> When you save the dashboard for the first time, you can manage dashboard permissions.
   ![](https://www.elastic.co/docs/explore-analyze/images/save-as-new-dashboard.png)
   When you create a dashboard, you become its owner and control who can access it. You can share your dashboard with one of the following permissions:
   - **Can edit**: Everybody in the space can edit, delete, and fully manage the dashboard.
- **Can view**: Everybody in the space can view the dashboard, but cannot edit or delete it. They can duplicate it. This read-only setting can be changed at any time by the dashboard owner or a Kibana administrator.
   The dashboard owner cannot be changed and is not visible from the UI. Note that if user A creates a dashboard, exports it, and user B re-imports it in the same space (overwriting the existing dashboard), user A remains the owner but user B becomes the creator.
   <note>
   Kibana administrators always have write access to all dashboards.
   </note>