﻿---
title: Building dashboards
description: Build powerful Kibana dashboards using visualizations, metrics, text, images, and interactive controls to monitor and analyze your data.
url: https://www.elastic.co/docs/explore-analyze/dashboards/building
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Building dashboards
Kibana offers many ways to build powerful dashboards that help you visualize and keep track of the most important information in your Elasticsearch data. Combine multiple visualizations, metrics, and interactive elements into a cohesive view that tells your data story and enables rapid decision-making.
You can:
- Create and assemble visualizations such as charts or maps, and enrich them with helpful legends containing key data
- Extract and show key indicators and metrics to always keep them visible and highlighted
- Add text, images, and links to help viewers make the most of your dashboard
- Include additional controls to facilitate filtering and browsing the data


## Requirements

To create or edit dashboards, you need:
- [Data indexed into Elasticsearch](https://www.elastic.co/docs/manage-data/ingest) and a [data view](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views). A data view is a subset of your Elasticsearch data, and allows you to load the right data when building a visualization or exploring it.
  <tip>
  If you don't have data at hand and still want to explore dashboards, you can import one of the [sample data sets](https://www.elastic.co/docs/manage-data/ingest/sample-data) available.
  </tip>
- Sufficient privileges for the **Dashboard** feature. Without them, you might get a read-only indicator. A Kibana administrator can [grant you the required privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).