﻿---
title: Resolve a cluster before cross-cluster search
description: You can use the _resolve/cluster endpoint before cross-cluster search to identify clusters or indices to exclude from your search. You may want to exclude...
url: https://www.elastic.co/docs/explore-analyze/cross-cluster-search/using-resolve-cluster-endpoint-before-cross-cluster-search
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Resolve a cluster before cross-cluster search
You can use the [`_resolve/cluster`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-resolve-cluster) endpoint before cross-cluster search to identify clusters or indices to exclude from your search.
You may want to exclude a cluster or index from a search when:
1. A remote cluster is unavailable and configured with `skip_unavailable`=`false`. Executing a cross-cluster search under those conditions will cause [the entire search to fail](/docs/explore-analyze/cross-cluster-search#cross-cluster-search-failures).
2. A cluster has no matching indices, aliases or data streams for the index expression, or your user does not have permissions to search them. For example, if your index expression is `logs*,remote1:logs*` and the `remote1` cluster has no matching indices, that cluster will return no results if included in a cross-cluster search.
3. The index expression, combined with any query parameters you specify, might trigger exceptions. In these cases, the "error" field in the `_resolve/cluster` response will be present. This is also where security/permission errors will be shown.
4. A remote cluster is running an older version that does not support features needed for your search.


## Examples

```json
```

The API returns the following response:
```json
{
  "(local)": {          
    "connected": true,
    "skip_unavailable": false,
    "matching_indices": true,
    "version": {
      "number": "8.13.0",
      "build_flavor": "default",
      "minimum_wire_compatibility_version": "7.17.0",
      "minimum_index_compatibility_version": "7.0.0"
    }
  },
  "cluster_one": {
    "connected": true,         
    "skip_unavailable": true,  
    "matching_indices": true,  
    "version": {
      "number": "8.13.0",      
      "build_flavor": "default",
      "minimum_wire_compatibility_version": "7.17.0",
      "minimum_index_compatibility_version": "7.0.0"
    }
  },
  "cluster_two": {
    "connected": true,
    "skip_unavailable": false,
    "matching_indices": true,
    "version": {
      "number": "8.13.0",
      "build_flavor": "default",
      "minimum_wire_compatibility_version": "7.17.0",
      "minimum_index_compatibility_version": "7.0.0"
    }
  }
}
```


### Identifying potential problems with your cross-cluster search

The following request shows several examples of how modifying your query can prevent search failures. Note also that a `timeout` of 5 seconds is sent, which sets the maximum time the query will wait for remote clusters to respond.
```json
```

```json
{
  "(local)": {
    "connected": true,
    "skip_unavailable": false,
    "error": "no such index [not_present]"  
  },
  "cluster_one": {
    "connected": true,
    "skip_unavailable": true,
    "matching_indices": false,    
    "version": {
      "number": "8.13.0",
      "build_flavor": "default",
      "minimum_wire_compatibility_version": "7.17.0",
      "minimum_index_compatibility_version": "7.0.0"
    }
  },
  "cluster_two": {
    "connected": false,           
    "skip_unavailable": false
  },
  "cluster_three": {
    "connected": false,
    "skip_unavailable": false,
    "error": "Request timed out before receiving a response from the remote cluster"  
  },
  "oldcluster": {         
    "connected": true,
    "skip_unavailable": false,
    "matching_indices": true
  }
}
```