﻿---
title: Watcher UI
description: Go to the Watcher page using the navigation menu or the global search field. With this UI, you can: Create a simple threshold watch, View your watch history...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/watcher-ui
applies_to:
  - Elastic Stack: Generally available
---

# Watcher UI
Go to the **Watcher** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). With this UI, you can:
- [Create a simple threshold watch](#watcher-create-threshold-alert)
- [View your watch history and action status](#watcher-getting-started)
- [Deactivate and delete a watch](#watcher-deactivate)
- [Create an advanced watch using API syntax](#watcher-create-advanced-watch)

![Watcher list](https://www.elastic.co/docs/explore-analyze/images/kibana-watches.png)
[Alerting on cluster and index events](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher) is a good source for detailed information on how watches work. If you are using the UI to create a threshold watch, take a look at the different watcher actions. If you are creating an advanced watch, you should be familiar with the parts of a watch—input, schedule, condition, and actions.
<note>
  There are limitations in **Watcher** that affect Kibana. For information, refer to [Limitations](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/watcher-limitations).
</note>


## Watcher security

To use Watcher in Kibana, you must have the built-in `kibana_admin` role and either of these Watcher roles:
- `watcher_admin`. You can perform all Watcher actions, including create and edit watches.
- `watcher_user`. You can view watches, but not create or edit them.

To manage roles, go to the **Roles** management page, or use the [role APIs](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-roles). Watches are shared between all users with the same role.
<note>
  If you are creating a threshold watch, you must also have the `view_index_metadata` index privilege. See [Index management](/docs/manage-data/data-store/index-basics#index-management) for detailed information.
</note>


## Create a threshold alert

A threshold alert is one of the most common types of watches that you can create. This alert periodically checks when your data is above, below, equals, or is in between a certain threshold within a given time interval.
The following example walks you through creating a threshold alert. The alert is triggered when the maximum total CPU usage on a machine goes above a certain percentage. The example uses [Metricbeat](https://www.elastic.co/products/beats/metricbeat) to collect metrics from your systems and services. [Learn more](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) on how to install and get started with Metricbeat.

### Define the watch input and schedule

1. Click **Create** and then select **Create threshold alert**.
   You’re navigated to a page where you’re asked to define the watch name, the data that you want to evaluate, and how often you want to trigger the watch.
2. Enter a name that you want to call the alert, for example, `cpu_threshold_alert`.
3. In the **Indices to query** field, enter `metricbeat-*` and select `@timestamp` as the time field.
4. Use the default schedule to run the watch every 1 minute.
   ![Input and schedule for threshold alert](https://www.elastic.co/docs/explore-analyze/images/kibana-create-threshold-alert-created.png)


### Add a condition

You should now see a panel with default conditions and a visualization of the data based on those conditions. The condition evaluates the data you’ve loaded into the watch and determines if any action is required.
1. Click the `WHEN` expression and change the value to `max()`.
   The `OF` expression now appears.
2. Search for `system.process.cpu.total.norm.pct` and select it from the list.
3. Select the `IS ABOVE` expression and change the value to `.25` to trigger an alert whenever the CPU is above 25%.
   As you change the condition, the visualization is automatically updated. The black line represents the threshold (25%), while the green fluctuating line represents the change in CPU over the set time period.
   ![Condition for threshold alert](https://www.elastic.co/docs/explore-analyze/images/kibana-threshold-alert-condition.png)


### Add an action

Now that the condition is set, you must add an action. The action triggers when the watch condition is met. For a complete list of actions and how to configure them, see [Adding conditions to actions](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/action-conditions).
In this example, you’ll configure an email action. You must have an [email account configured](/docs/explore-analyze/alerts-cases/watcher/actions-email#configuring-email) in Elasticsearch for this example to work.
1. Click **Add action** and select **Email**.
2. In the **To email address** field, enter one or more email addresses to whom you want to send the message when the condition is met.
3. Enter a subject and body for the email.
4. To test the action before saving the watch, click **Send test email**.
   A sample email is sent using the configuration you set up.
5. Click **Create alert**.
   The alert appears on the Watcher overview page, where you can drill down into the watch history and status.


### Delete the alert

In this example, you set the threshold to 25% so you can see the watch execute its actions. In a real-world scenario, this threshold is likely too low because the alerts will be too frequent. Once you are done experimenting, you should delete the alert. Find the alert on the Watcher overview page and click the trash icon in the **Actions** column.

### Edit the alert

Alternatively, you can keep the alert and adjust the threshold value. To edit an alert, find the alert on the Watcher overview page and click the pencil icon in the **Actions** column.

## View watch history and status

The Watcher overview page lists your watches, including the state of each watch, when its condition was last met, when the condition was last checked, and whether any of its actions have been acknowledged, throttled, or failed to execute. Each watch can be in one of three states:
- **Active.** The watch is working properly.
- **Inactive.** The watch is working properly, but is deliberately disabled, so it won’t execute any actions.
- **Error.** The watch is not working properly.

From this page you can drill down into a watch to investigate its history and status.

### View watch history

The **Execution history** tab shows each time the watch is triggered and the results of the query, whether the condition was met, and what actions were taken.
![Execution history tab](https://www.elastic.co/docs/explore-analyze/images/kibana-execution-history.png)

### Acknowledge action status

The **Action statuses** tab lists all actions associated with the watch and the state of each action. Some actions can be acknowledged, which will prevent too many executions of that action for the relevant watch. See [Acknowledgement and throttling](/docs/explore-analyze/alerts-cases/watcher/actions#actions-ack-throttle) for details.
![Action status tab](https://www.elastic.co/docs/explore-analyze/images/kibana-alerts-status.png)

## Deactivate and delete a watch

Actions for deactivating and deleting a watch are on each watch detail page:
- **Deactivate a watch** if you know a situation is planned that will cause a false alarm. You can reactivate the watch when the situation is resolved.
- **Delete a watch** to permanently remove it from the system. You can delete the watch you are currently viewing, or go to the Watcher overview, and delete watches in bulk.


## Create an advanced watch

Advanced watches are for users who are more familiar with Elasticsearch query syntax and the Watcher framework. The UI is aligned with using the REST APIs. For more information, see [Query DSL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl).

### Create the watch

On the Watch overview page, click **Create** and choose **Create advanced watch**. An advanced watch requires a name and ID.  Name is a user-friendly way to identify the watch, and ID refers to the identifier used by Elasticsearch.  Refer to [Watch definition](/docs/explore-analyze/alerts-cases/watcher/how-watcher-works#watch-definition) for how to input the watch JSON.
![Create advanced watch](https://www.elastic.co/docs/explore-analyze/images/kibana-advanced-watch-create.png)

### Simulate the watch

The **Simulate** tab allows you to override parts of the watch, and then run a simulation. Be aware of these implementation details on overrides:
- Trigger overrides use [date math](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options#date-math).
- Input overrides accepts a JSON blob.
- Condition overrides indicates if you want to force the condition to always be `true`.
- Action overrides support [multiple options](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-execute-watch).

Some watches, such as those using basic auth credentials, contain passwords. For security reasons, these passwords will be stripped from any watches that are loaded by the Watcher UI. You will need to manually re-enter these passwords to simulate the watch.
After starting the simulation, you’ll see a results screen. For more information on the fields in the response, see the [Execute watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-execute-watch).
![Create advanced watch](https://www.elastic.co/docs/explore-analyze/images/kibana-advanced-watch-simulate.png)

### Examples of advanced watches

Refer to these examples for creating an advanced watch:
- [Watch the status of an Elasticsearch cluster](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/watch-cluster-status)
- [Watch event data](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/example-watches)