﻿---
title: Watching the status of an Elasticsearch cluster
description: You can easily configure a basic watch to monitor the health of your Elasticsearch cluster: Schedule the watch and define an input that gets the cluster...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/watch-cluster-status
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Watching the status of an Elasticsearch cluster
You can easily configure a basic watch to monitor the health of your Elasticsearch cluster:
- [Schedule the watch and define an input](#health-add-input) that gets the cluster health status.
- [Add a condition](#health-add-condition) that evaluates the health status to determine if action is required.
- [Take action](#health-take-action) if the cluster is RED.


## Schedule the watch and add an input

A watch [schedule](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/trigger-schedule) controls how often a watch is triggered. The watch [input](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input) gets the data that you want to evaluate.
The simplest way to define a schedule is to specify an interval. For example, the following schedule runs every 10 seconds:
```json

{
  "trigger" : {
    "schedule" : { "interval" : "10s" } <1>
  }
}
```

To get the status of your cluster, you can call the [cluster health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health):
```json
```

To load the health status into your watch, you simply add an [HTTP input](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input-http) that calls the cluster health API:
```json

{
  "trigger" : {
    "schedule" : { "interval" : "10s" }
  },
  "input" : {
    "http" : {
      "request" : {
        "host" : "localhost",
        "port" : 9200,
        "path" : "/_cluster/health"
      }
    }
  }
}
```

If you’re using Security, then you’ll also need to supply some authentication credentials as part of the watch configuration:
```json

{
  "trigger" : {
    "schedule" : { "interval" : "10s" }
  },
  "input" : {
    "http" : {
      "request" : {
        "host" : "localhost",
        "port" : 9200,
        "path" : "/_cluster/health",
        "auth": {
          "basic": {
            "username": "elastic",
            "password": "x-pack-test-password"
          }
        }
      }
    }
  }
}
```

It would be a good idea to create a user with the minimum privileges required for use with such a watch configuration.
Depending on how your cluster is configured, there may be additional settings required before the watch can access your cluster such as keystores, truststores, or certificates. For more information, see [Watcher settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/watcher-settings).
If you check the watch history, you’ll see that the cluster status is recorded as part of the `watch_record` each time the watch executes.
For example, the following request retrieves the last ten watch records from the watch history:
```json

{
  "sort" : [
    { "result.execution_time" : "desc" }
  ]
}
```


## Add a condition

A [condition](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition) evaluates the data you’ve loaded into the watch and determines if any action is required. Since you’ve defined an input that loads the cluster status into the watch, you can define a condition that checks that status.
For example, you could add a condition to check to see if the status is RED.
```json

{
  "trigger" : {
    "schedule" : { "interval" : "10s" } <1>
  },
  "input" : {
    "http" : {
      "request" : {
       "host" : "localhost",
       "port" : 9200,
       "path" : "/_cluster/health"
      }
    }
  },
  "condition" : {
    "compare" : {
      "ctx.payload.status" : { "eq" : "red" }
    }
  }
}
```

If you check the watch history, you’ll see that the condition result is recorded as part of the `watch_record` each time the watch executes.
To check to see if the condition was met, you can run the following query.
```json

{
  "query" : {
    "match" : { "result.condition.met" : true }
  }
}
```


## Take action

Recording `watch_records` in the watch history is nice, but the real power of Watcher is being able to do something in response to an alert. A watch’s [actions](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/actions) define what to do when the watch condition is true—you can send emails, call third-party webhooks, or write documents to an Elasticsearch index or log when the watch condition is met.
For example, you could add an action to index the cluster status information when the status is RED.
```json

{
  "trigger" : {
    "schedule" : { "interval" : "10s" }
  },
  "input" : {
    "http" : {
      "request" : {
       "host" : "localhost",
       "port" : 9200,
       "path" : "/_cluster/health"
      }
    }
  },
  "condition" : {
    "compare" : {
      "ctx.payload.status" : { "eq" : "red" }
    }
  },
  "actions" : {
    "send_email" : {
      "email" : {
        "to" : "username@example.org",
        "subject" : "Cluster Status Warning",
        "body" : "Cluster status is RED"
      }
    }
  }
}
```

For Watcher to send email, you must configure an email account in your [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file and restart Elasticsearch. To add an email account, set the `xpack.notification.email.account` property.
For example, the following snippet configures a single Gmail account named `work`:
```yaml
xpack.notification.email.account:
  work:
    profile: gmail
    email_defaults:
      from: <email> 
    smtp:
      auth: true
      starttls.enable: true
      host: smtp.gmail.com
      port: 587
      user: <username> 
      password: <password> 
```

<note>
  If you have advanced security options enabled for your email account, you need to take additional steps to send email from Watcher. For more information, see [Configuring email accounts](/docs/explore-analyze/alerts-cases/watcher/actions-email#configuring-email).
</note>

You can check the watch history or the `status_index` to see that the action was performed.
```json

{
  "query" : {
    "match" : { "result.condition.met" : true }
  }
}
```


## Delete the watch

Since the `cluster_health_watch` is configured to run every 10 seconds, make sure you delete it when you’re done experimenting. Otherwise, you’ll spam yourself indefinitely.
To remove the watch, use the [delete watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-delete-watch):
```json
```