﻿---
title: Transforms
description: A payload transform processes and changes the payload in the watch execution context to prepare it for the watch actions. Watcher supports three types...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Transforms
A *payload transform* processes and changes the payload in the watch execution context to prepare it for the watch actions. Watcher supports three types of payload transforms:
- [`search`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-search)
- [`script`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-script)
- [`chain`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-chain)

<note>
  Payload transforms are optional. When none are defined, the actions have access to the payload as loaded by the watch input.
</note>

You can define payload transforms in two places:
- As a top level construct in the watch definition. In this case, the payload is transformed before any of the watch actions are executed.
- As part of the definition of an action. In this case, the payload is transformed before that action is executed. The transformation is only applied to the payload for that specific action.

If all actions require the same view of the payload, define a payload transform as part of the watch definition. If each action requires a different view of the payload, define different payload transforms as part of the action definitions so each action has the payload prepared by its own dedicated payload transform.
The following example defines two payload transforms, one at the watch level and one as part of the definition of the `my_webhook` action.
```js
{
  "trigger" : { ...}
  "input" : { ... },
  "condition" : { ... },
  "transform" : { 
    "search" : {
      "request": {
        "body" : { "query" : { "match_all" : {} } }
      }
    }
  },
  "actions" : {
    "my_webhook": {
      "transform" : { 
      	"script" : "return ctx.payload.hits"
      },
      "webhook" : {
      	"host" : "host.domain",
      	"port" : 8089,
      	"path" : "/notify/{{ctx.watch_id}}"
      }
    }
  ]
}
```