﻿---
title: Script payload transform
description: A payload transform that executes a script on the current payload in the watch execution context and replaces it with a newly generated one. The following...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-script
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Script payload transform
A [payload transform](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform) that executes a script on the current payload in the watch execution context and replaces it with a newly generated one. The following snippet shows how a simple script payload transform can be defined on the watch level:
<tip>
  The `script` payload transform is often useful when used in combination with the [`search`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-search) payload transform, where the script can extract only the significant data from a search result, and by that, keep the payload minimal. This can be achieved with the [`chain`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-chain) payload transform.
</tip>

```js
{
  "transform" : {
    "script" : "return [ 'time' : ctx.trigger.scheduled_time ]" 
  }
}
```

<note>
  The executed script may either return a valid model that is the equivalent of a Java™ Map or a JSON object (you will need to consult the documentation of the specific scripting language to find out what this construct is). Any other value that is returned will be assigned and accessible to/via the `_value` variable.
</note>


## Script settings

The `script` attribute may hold a string value in which case it will be treated as an inline script and the default Elasticsearch script languages will be assumed (as described in [Scripting](https://www.elastic.co/docs/explore-analyze/scripting)). You can use the other scripting languages supported by Elasticsearch. For this, you need to set the `script` field to an object describing the script and its language. The following table lists the possible settings that can be configured:

| Name     | Required | Default    | Description                                                                                                   |
|----------|----------|------------|---------------------------------------------------------------------------------------------------------------|
| `inline` | yes      | -          | When using an inline script, this field holds                                     the script itself.          |
| `id`     | yes      | -          | When referring to a stored script, this                                     field holds the id of the script. |
| `lang`   | no       | `painless` | The script language                                                                                           |
| `params` | no       | -          | Additional parameters/variables that are                                     accessible by the script         |

When using the object notation of the script, one (and only one) of `inline`, or `id` fields must be defined.
<note>
  In addition to the provided `params`, the scripts also have access to the [standard watch execution context parameters](/docs/explore-analyze/alerts-cases/watcher/how-watcher-works#watch-execution-context).
</note>