﻿---
title: Chain payload transform
description: A payload transform that executes an ordered list of configured payload transforms in a chain, where the output of one transform serves as the input of...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-chain
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Chain payload transform
A [payload transform](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform) that executes an ordered list of configured payload transforms in a chain, where the output of one transform serves as the input of the next transform in the chain. The payload that is accepted by this transform serves as the input of the first transform in the chain and the output of the last transform in the chain is the output of the `chain` transform as a whole.
You can use chain payload transforms to build more complex transforms out of the other available transforms. For example, you can combine a [`search`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-search) payload transform and a [`script`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-script) payload transform, as shown in the following snippet:
```js
"transform" : {
  "chain" : [ 
    {
      "search" : {  
        "request": {
          "indices" : [ "logstash-*" ],
          "body" : {
            "size" : 0,
            "query" : {
              "match" : { "priority" : "error" }
            }
          }
        }
      }
    },
    {
      "script" : "return [ 'error_count' : ctx.payload.hits.total ]"  
    }
  ]
}
```

This example executes a `count` search on the cluster to look for `error` events. The search results are then passed to the second `script` payload transform. The `script` payload transform extracts the total hit count and assigns it to the `error_count` field in a newly-generated payload. This new payload is the output of the `chain` payload transform and replaces the payload in the watch execution context.