﻿---
title: Managing watches
description: Watcher provides as set of APIs you can use to manage your watches: Use the create or update watch API to add or update watches, Use the get watch API...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/managing-watches
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Managing watches
Watcher provides as set of APIs you can use to manage your watches:
- Use the [create or update watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-put-watch) to add or update watches
- Use the [get watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-get-watch) to retrieve watches
- Use the [delete watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-delete-watch) to delete watches
- Use the [activate watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-activate-watch) to activate watches
- Use the [deactivate watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-deactivate-watch) to deactivate watches
- Use the [ack watch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-ack-watch) to acknowledge watches


## Listing watches

Currently there is no dedicated API for listing the stored watches. However, since Watcher stores its watches in the `.watches` index, you can list them by executing a search on this index.
<important>
  You can only perform read actions on the `.watches` index. You must use the Watcher APIs to create, update, and delete watches. If Elasticsearch security features are enabled, we recommend you only grant users `read` privileges on the `.watches` index.
</important>

For example, the following returns the first 100 watches:
```json

{
  "size" : 100
}
```