﻿---
title: Inputs
description: When a watch is triggered, its input loads data into the execution context. This payload is accessible during the subsequent watch execution phases. For...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Inputs
When a watch is triggered, its *input* loads data into the execution context. This payload is accessible during the subsequent watch execution phases. For example, you can base a watch’s condition on the data loaded by its input.
Watcher supports four input types:
- [`simple`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input-simple): load static data into the execution context.
- [`search`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input-search): load the results of a search into the execution context.
- [`http`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input-http): load the results of an HTTP request into the execution context.
- [`chain`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input-chain): use a series of inputs to load data into the execution context.

<note>
  If you don’t define an input for a watch, an empty payload is loaded into the execution context.
</note>