﻿---
title: Chain input
description: Use the chain input to load data from multiple sources into the watch execution context when the watch is triggered. The inputs in a chain are processed...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/input-chain
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Chain input
Use the `chain` input to load data from multiple sources into the watch execution context when the watch is triggered. The inputs in a chain are processed in order and the data loaded by an input can be accessed by the subsequent inputs in the chain.
The `chain` input enables you to perform actions based on data from multiple sources. You can also use the data collected by one input to load data from another source.
For example, the following chain input loads data from an HTTP server using the path set by a `simple` input:
```js
"input" : {
  "chain" : {
    "inputs" : [ 
      {
        "first" : {
          "simple" : { "path" : "/_search" }
        }
      },
      {
        "second" : {
          "http" : {
            "request" : {
              "host" : "localhost",
              "port" : 9200,
              "path" : "{{ctx.payload.first.path}}" 
            }
          }
        }
      }
    ]
  }
}
```


## Accessing chained input data

To reference data loaded by a particular input, you use the input’s name, `ctx.payload.<input-name>.<value>`.

## Transforming chained input data

In certain use-cases the output of the first input should be used as input in a subsequent input. This requires you to do a transform, before you pass the data on to the next input.
In order to achieve this you can use a transform input between the two specified inputs, see the following example. Note, that the first input will still be available in its original form in `ctx.payload.first`.
```js
"input" : {
  "chain" : {
    "inputs" : [
      {
        "first" : {
          "simple" : { "path" : "/_search" }
        }
      },
      {
        "second" : {
          "transform" : {
            "script" : "return [ 'path' : ctx.payload.first.path + '/' ]"
          }
        }
      },
      {
        "third" : {
          "http" : {
            "request" : {
              "host" : "localhost",
              "port" : 9200,
              "path" : "{{ctx.payload.second.path}}"
            }
          }
        }
      }
    ]
  }
}
```