﻿---
title: Execute a watch
description: The execute endpoint lets you manually trigger the execution of a watch for testing or debugging purposes, without waiting for its scheduled trigger...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/execute-watch
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Execute a watch
The [execute endpoint](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-watcher-execute-watch) lets you manually trigger the execution of a watch for testing or debugging purposes, without waiting for its scheduled trigger. You can simulate watch execution, override its input and condition, and control how individual actions behave during the run.
The examples below show how to execute an existing watch, customize its behavior during execution, and run an inline watch definition.
Here's a detailed example of executing the `my_watch` watch with various optional parameters:
```json

{
  "trigger_data" : { <1>
     "triggered_time" : "now",
     "scheduled_time" : "now"
  },
  "alternative_input" : { <2>
    "foo" : "bar"
  },
  "ignore_condition" : true, <3>
  "action_modes" : {
    "my-action" : "force_simulate" <4>
  },
  "record_execution" : true <5>
}
```

This is an example of the output:
```json
{
  "_id": "my_watch_0-2015-06-02T23:17:55.124Z", <1>
  "watch_record": { <2>
    "@timestamp": "2015-06-02T23:17:55.124Z",
    "watch_id": "my_watch",
    "node": "my_node",
    "messages": [],
    "trigger_event": {
      "type": "manual",
      "triggered_time": "2015-06-02T23:17:55.124Z",
      "manual": {
        "schedule": {
          "scheduled_time": "2015-06-02T23:17:55.124Z"
        }
      }
    },
    "state": "executed",
    "status": {
      "version": 1,
      "execution_state": "executed",
      "state": {
        "active": true,
        "timestamp": "2015-06-02T23:17:55.111Z"
      },
      "last_checked": "2015-06-02T23:17:55.124Z",
      "last_met_condition": "2015-06-02T23:17:55.124Z",
      "actions": {
        "test_index": {
          "ack": {
            "timestamp": "2015-06-02T23:17:55.124Z",
            "state": "ackable"
          },
          "last_execution": {
            "timestamp": "2015-06-02T23:17:55.124Z",
            "successful": true
          },
          "last_successful_execution": {
            "timestamp": "2015-06-02T23:17:55.124Z",
            "successful": true
          }
        }
      }
    },
    "input": {
      "simple": {
        "payload": {
          "send": "yes"
        }
      }
    },
    "condition": {
      "always": {}
    },
    "result": { <3>
      "execution_time": "2015-06-02T23:17:55.124Z",
      "execution_duration": 12608,
      "input": {
        "type": "simple",
        "payload": {
          "foo": "bar"
        },
        "status": "success"
      },
      "condition": {
        "type": "always",
        "met": true,
        "status": "success"
      },
      "actions": [
        {
          "id": "test_index",
          "index": {
            "response": {
              "index": "test",
              "version": 1,
              "created": true,
              "result": "created",
              "id": "AVSHKzPa9zx62AzUzFXY"
            }
          },
          "status": "success",
          "type": "index"
        }
      ]
    },
    "user": "test_admin" <4>
  }
}
```

You can set a different execution mode for every action by associating the mode
name with the action id:
```json

{
  "action_modes" : {
    "action1" : "force_simulate",
    "action2" : "skip"
  }
}
```

You can also associate a single execution mode with all the actions in the watch
using `_all` as the action id:
```json

{
  "action_modes" : {
    "_all" : "force_execute"
  }
}
```

The following example shows how to execute a watch inline:
```json

{
  "watch" : {
    "trigger" : { "schedule" : { "interval" : "10s" } },
    "input" : {
      "search" : {
        "request" : {
          "indices" : [ "logs" ],
          "body" : {
            "query" : {
              "match" : { "message": "error" }
            }
          }
        }
      }
    },
    "condition" : {
      "compare" : { "ctx.payload.hits.total" : { "gt" : 0 }}
    },
    "actions" : {
      "log_error" : {
        "logging" : {
          "text" : "Found {{ctx.payload.hits.total}} errors in the logs"
        }
      }
    }
  }
}
```

All other settings for this API still apply when inlining a watch. In the
following snippet, while the inline watch defines a `compare` condition,
during the execution this condition will be ignored:
```json

{
  "ignore_condition" : true,
  "watch" : {
    "trigger" : { "schedule" : { "interval" : "10s" } },
    "input" : {
      "search" : {
        "request" : {
          "indices" : [ "logs" ],
          "body" : {
            "query" : {
              "match" : { "message": "error" }
            }
          }
        }
      }
    },
    "condition" : {
      "compare" : { "ctx.payload.hits.total" : { "gt" : 0 }}
    },
    "actions" : {
      "log_error" : {
        "logging" : {
          "text" : "Found {{ctx.payload.hits.total}} errors in the logs"
        }
      }
    }
  }
}
```