﻿---
title: Encrypting sensitive data in Watcher
description: Watches might have access to sensitive data such as HTTP basic authentication information or details about your SMTP email service. You can encrypt this...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/encrypting-data
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Encrypting sensitive data in Watcher
Watches might have access to sensitive data such as HTTP basic authentication information or details about your SMTP email service. You can encrypt this data by generating a key and adding some secure settings on each node in your cluster.
Every `password` field that is used in your watch within an HTTP basic authentication block - for example within a webhook, an HTTP input or when using the reporting email attachment - will not be stored as plain text anymore. Also be aware, that there is no way to configure your own fields in a watch to be encrypted.
To encrypt sensitive data in Watcher:
1. Use the [elasticsearch-syskeygen](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/syskeygen) command to create a system key file.
2. Copy the `system_key` file to all of the nodes in your cluster.
   <important>
   The system key is a symmetric key, so the same key must be used on every node in the cluster.
   </important>
3. Set the [`xpack.watcher.encrypt_sensitive_data` setting](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/watcher-settings):
   ```sh
   xpack.watcher.encrypt_sensitive_data: true
   ```
4. Set the [`xpack.watcher.encryption_key` setting](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/watcher-settings) in the [Elasticsearch keystore](https://www.elastic.co/docs/deploy-manage/security/secure-settings) on each node in the cluster.
   For example, run the following command to import the `system_key` file on each node:
   ```sh
   bin/elasticsearch-keystore add-file xpack.watcher.encryption_key <filepath>/system_key
   ```
5. Delete the `system_key` file on each node in the cluster.

<note>
  Existing watches are not affected by these changes. Only watches that you create after following these steps have encryption enabled.
</note>