﻿---
title: Conditions
description: When a watch is triggered, its condition determines whether or not to execute the watch actions. Watcher supports the following condition types: always:...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Conditions
When a watch is triggered, its condition determines whether or not to execute the watch actions. Watcher supports the following condition types:
- [`always`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-always): The condition always evaluates to `true`, so the watch actions are always performed.
- [`never`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-never): The condition always evaluates to `false`, so the watch actions are never executed.
- [`compare`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-compare): perform simple comparisons against values in the watch payload to determine whether or not to execute the watch actions.
- [`array_compare`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-array-compare): compare an array of values in the watch payload to a given value to determine whether or not to execute the watch actions.
- [`script`](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-script): use a script to determine whether or not to execute the watch actions.

<note>
  If you omit the condition definition from a watch, the condition defaults to `always`.
</note>

When a condition is evaluated, it has full access to the watch execution context, including the watch payload (`ctx.payload.*`). The [script](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-script), [compare](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-compare)  and [array_compare](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-array-compare) conditions can use the payload data to determine whether or not the necessary conditions are met.
In addition to the watch wide condition, you can also configure conditions per [action](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/action-conditions).