﻿---
title: Array compare condition
description: Use array_compare to compare an array of values in the execution context to a given value. See Table 84 for the operators you can use. To use the array_compare...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-array-compare
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Array compare condition
Use `array_compare` to compare an array of values in the execution context to a given value. See [Table 84](/docs/explore-analyze/alerts-cases/watcher/condition-compare#condition-compare-operators) for the operators you can use.

## Using an array compare condition

To use the `array_compare` condition, you specify the array in the execution context that you want to evaluate, a [comparison operator](/docs/explore-analyze/alerts-cases/watcher/condition-compare#condition-compare-operators), and the value you want to compare against. Optionally, you can specify the path to the field in each array element that you want to evaluate.
For example, the following `array_compare` condition returns `true` if there is at least one bucket in the aggregation that has a `doc_count` greater than or equal to 25:
```js
{
  "condition": {
    "array_compare": {
      "ctx.payload.aggregations.top_tweeters.buckets" : { 
        "path": "doc_count", 
        "gte": { 
          "value": 25 
        }
      }
    }
  }
}
```

<note>
  When using fieldnames that contain a dot this condition will not work, use a [script condition](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-script) instead.
</note>


## Array-compare condition attributes


| Name                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
|--------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `<array path>`                       | The path to the array in the execution                                         context, specified in dot notation.                                         For example, `ctx.payload.aggregations.top_tweeters.buckets`.                                                                                                                                                                                                                                                                                                                                                           |
| `<array path>.path`                  | The path to the field in each array element                                         that you want to evaluate. For example,                                         `doc_count`. Defaults to an empty string.                                                                                                                                                                                                                                                                                                                                                                      |
| `<array path>.<operator>.quantifier` | How many matches are required for the                                         comparison to evaluate to `true`: `some`                                         or `all`. Defaults to `some`--there must                                         be at least one match. If the array is                                         empty, the comparison evaluates to `true`                                         if the quantifier is set to `all` and                                         `false` if the quantifier is set to                                         `some`. |
| `<array path>.<operator>.value`      | The value to compare against.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |