﻿---
title: Logging action
description: Use the logging action to log text to the standard Elasticsearch logs. See Logging action attributes for the supported attributes. This action is primarily...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/actions-logging
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Logging action
Use the `logging` action to log text to the standard Elasticsearch logs. See [Logging action attributes](#logging-action-attributes) for the supported attributes.
This action is primarily used during development and for debugging purposes.

## Configuring logging actions

You configure logging actions in the `actions` array. Action-specific attributes are specified using the `logging` keyword.
The following snippet shows a simple logging action definition:
```js
"actions" : {
  "log" : { 
    "transform" : { ... }, 
    "logging" : {
      "text" : "executed at {{ctx.execution_time}}" 
    }
  }
}
```


## Logging action attributes


| Name       | Required | Default                       | Description                                                                                                                                                                                                          |
|------------|----------|-------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `text`     | yes      | -                             | The text that should be logged. Can be static text or                                                          include Mustache [templates](/docs/explore-analyze/alerts-cases/watcher/how-watcher-works#templates). |
| `category` | no       | xpack.watcher.actions.logging | The category under which the text will be logged.                                                                                                                                                                    |
| `level`    | no       | info                          | The logging level. Valid values are: `error`, `warn`,                                                          `info`, `debug` and `trace`.                                                                          |