﻿---
title: Index action
description: Use the index action to index data into Elasticsearch. See Index action attributes for the supported attributes. The following snippet shows a simple...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/actions-index
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Index action
Use the `index` action to index data into Elasticsearch. See [Index action attributes](#index-action-attributes) for the supported attributes.

## Configuring index actions

The following snippet shows a simple `index` action definition:
```js
"actions" : {
  "index_payload" : { 
    "condition": { ... }, 
    "transform": { ... }, 
    "index" : {
      "index" : "my-index-000001", 
      "doc_id": "my-id" 
    }
  }
}
```


## Index action attributes


| Name                   | Required | Default | Description                                                                                                                                                                                                                                                                                                                                              |
|------------------------|----------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `index`                | yes*     | -       | The index, alias, or data stream to index into. Date math expressions like `<my-index-{now/d}>` are also supported.*If you dynamically set an `_index` value, this parameter isn’t required. See [Multi-document support](#anatomy-actions-index-multi-doc-support).                                                                                     |
| `doc_id`               | no       | -       | The optional `_id` of the document.                                                                                                                                                                                                                                                                                                                      |
| `op_type`              | no       | `index` | The [op_type](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) for the index operation.                                                      Must be one of either `index` or `create`. Must be `create` if                                                      `index` is a data stream.                                  |
| `execution_time_field` | no       | -       | The field that will store/index the watch execution                                                      time.                                                                                                                                                                                                                                           |
| `timeout`              | no       | 60s     | The timeout for waiting for the index api call to                                                      return. If no response is returned within this time,                                                      the index action times out and fails. This setting                                                      overrides the default timeouts. |
| `refresh`              | no       | -       | Optional setting of the [refresh policy](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/refresh-parameter)                                                      for the write request                                                                                                                                                     |


## Multi-document support

Like with all other actions, you can use a [transform](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform) to replace the current execution context payload with another and by that change the document that will end up indexed.
The index action plays well with transforms with its support for the special `_doc` payload field.
When resolving the document to be indexed, the index action first looks up for a `_doc` field in the payload. When not found, the payload is indexed as a single document.
When a `_doc` field exists, if the field holds an object, it is extracted and indexed as a single document. If the field holds an array of objects, each object is treated as a document and the index action indexes all of them in a bulk.
An `_index`, or `_id` value can be added per document to dynamically set the index and ID of the indexed document.
The following snippet shows a multi-document `index` action definition:
```js
"actions": {
  "index_payload": {
    "transform": {
      "script": """
      def documents = ctx.payload.hits.hits.stream()
        .map(hit -> [
          "_index": "my-index-000001", 
          "_id": hit._id, 
          "severity": "Sev: " + hit._source.severity 
        ])
        .collect(Collectors.toList());
      return [ "_doc" : documents]; 
      """
    },
    "index": {} 
  }
}
```