﻿---
title: Watcher
description: You can use Watcher to watch for changes or anomalies in your data and perform the necessary actions in response. For example, you might want to: Monitor...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher
products:
  - Elastic Cloud Hosted
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Watcher
<tip>
  Kibana Alerting provides a set of built-in actions and alerts that are integrated with applications such as APM, Metrics, Security, and Uptime. You can use Kibana Alerting to detect complex conditions within different Kibana apps and trigger actions when those conditions are met. For more information, refer to [Alerts and Cases](https://www.elastic.co/docs/explore-analyze/alerts-cases).
</tip>

You can use Watcher to watch for changes or anomalies in your data and perform the necessary actions in response. For example, you might want to:
- Monitor social media as another way to detect failures in user-facing automated systems like ATMs or ticketing systems. When the number of tweets and posts in an area exceeds a threshold of significance, notify a service technician.
- Monitor your infrastructure, tracking disk usage over time. Open a helpdesk ticket when any servers are likely to run out of free space in the next few days.
- Track network activity to detect malicious activity, and proactively change firewall configuration to reject the malicious user.
- Monitor Elasticsearch, and send immediate notification to the system administrator if nodes leave the cluster or query throughput exceeds an expected range.
- Track application response times and if page-load time exceeds SLAs for more than 5 minutes, open a helpdesk ticket. If SLAs are exceeded for an hour, page the administrator on duty.

All of these use-cases share a few key properties:
- The relevant data or changes in data can be identified with a periodic Elasticsearch query.
- The results of the query can be checked against a condition.
- One or more actions are taken if the condition is true — an email is sent, a 3rd party system is notified, or the query results are stored.


## How watches work

The alerting features provide an API for creating, managing and testing *watches*. A watch describes a single alert and can contain multiple notification actions.
A watch is constructed from four simple building blocks:
<definitions>
  <definition term="Schedule">
    A schedule for running a query and checking the condition.
  </definition>
  <definition term="Query">
    The query to run as input to the condition. Watches support the full Elasticsearch query language, including aggregations.
  </definition>
  <definition term="Condition">
    A condition that determines whether or not to execute the actions. You can use simple conditions (always true), or use scripting for more sophisticated scenarios.
  </definition>
  <definition term="Actions">
    One or more actions, such as sending email, pushing data to 3rd party systems through a webhook, or indexing the results of the query.
  </definition>
</definitions>

A full history of all watches is maintained in an Elasticsearch index. This history keeps track of each time a watch is triggered and records the results from the query, whether the condition was met, and what actions were taken.

## Backup and restore

You can back up and restore watches using the [snapshot and restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) functionality.
Make sure your snapshots include the `watcher` feature state. By default, snapshots include all feature states, unless explicitly configured otherwise. For more information, refer to [feature states](/docs/deploy-manage/tools/snapshot-and-restore#feature-state) in the snapshots documentation.
To restore your defined watches, restore the `watcher` feature state from a snapshot.

### Exporting watches using the Watcher API

As an alternative, you can export watch definitions using the `/_watcher/_query/watches` API, as described in [Listing watches](/docs/explore-analyze/alerts-cases/watcher/managing-watches#listing-watches).
This approach allows you to retrieve watch definitions in JSON format and is useful for inspection, migration between clusters, or storing watches in version control systems. Using the API, you can also filter and export only specific watches instead of all defined watches.