﻿---
title: Configure access to cases in Kibana
description: To access cases in Stack Management, you must have the appropriate Kibana privileges: Kibana privileges All for the Cases feature under Management.All...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/setup-cases
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure access to cases in Kibana
To access cases in **Stack Management**, you must have the appropriate Kibana privileges:

## Give full access to manage cases and settings

**Kibana privileges**
- `All` for the **Cases** feature under **Management**.
- `All` for the **Actions and Connectors** feature under **Management**.

<note>
  The **Actions and Connectors** feature privilege is required to create, add, delete, and modify case connectors and to send updates to external systems.By default, `All` for the **Cases** feature allows you to have full control over cases, including deleting them, editing case settings, and more. You can customize the sub-feature privileges to limit feature access.
</note>


## Give assignee access to cases

**Kibana privileges**
- `All` for the **Cases** feature under **Management**.

<note>
  Before a user can be assigned to a case, they must log into Kibana at least once, which creates a user profile.This privilege is also required to add [case actions](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type) to rules.
</note>


## Give view-only access to cases

**Kibana privileges**
- `Read` for the **Cases** feature under **Management**.

<note>
  You can customize sub-feature privileges for deleting cases and comments, editing case settings, adding case comments and attachments, and re-opening cases.
</note>


## Revoke all access to cases

**Kibana privileges**
`None` for the **Cases** feature under **Management**.

## More details

For more details, refer to [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).
<note>
  If you are using an on-premises Kibana deployment and you want the email notifications and the external incident management systems to contain links back to Kibana, you must configure the [`server.publicBaseUrl`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) setting.
</note>