﻿---
title: Open and manage cases in Kibana
description: Open a new case to keep track of issues and share their details with colleagues. You can create and manage cases using the cases UI. To open a case: Go...
url: https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/manage-cases
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Open and manage cases in Kibana
Open a new case to keep track of issues and share their details with colleagues. You can create and manage cases using the cases UI.
<note>
  **Requirements**To access and send cases to external systems, you need the appropriate [subscription or feature tier](https://www.elastic.co/pricing), and your role must have the required Kibana feature privileges. Refer to [Configure access to cases in Kibana](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/setup-cases) for more information.
</note>


## Open a new case

To open a case:
1. Go to **Management > Stack Management > Cases**, then click **Create case**.
   ![Create a case in Stack Management](https://www.elastic.co/docs/explore-analyze/images/kibana-cases-create.png)
2. If you defined [templates](/docs/explore-analyze/alerts-cases/cases/manage-cases-settings#case-templates), you can optionally select one to use its default field values.
3. Give the case a name, severity, and description.
   <tip>
   In the `Description` area, you can use [Markdown](https://www.markdownguide.org/cheat-sheet) syntax to create formatted text.
   </tip>
4. Optionally, add a category, assignees, and tags. You can add users only if they meet the necessary [prerequisites](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/setup-cases).
5. If you defined any [custom fields](/docs/explore-analyze/alerts-cases/cases/manage-cases-settings#case-custom-fields), they appear in the **Additional fields** section.
6. (Optional) Under **External Connector Fields**, you can select a connector to send cases to an external system. If you’ve created any connectors previously, they will be listed here. If there are no connectors listed, you can create one. For more information, refer to [External incident management systems](/docs/explore-analyze/alerts-cases/cases/manage-cases-settings#case-connectors).
   <note applies-to="Elastic Stack: Generally available since 9.3">
   When specifying **Additional fields** for an IBM Resilient connector, fields that are set when an incident is created or changed (for example, an incident is closed) won't display as an option.
   </note>
7. After you’ve completed all of the required fields, click **Create case**.

<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> Alternatively, you can configure your rules to automatically create cases by using [case actions](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type). By default, the rule adds all of the alerts within a specified time window to a single case. You can optionally choose a field to group the alerts and create separate cases for each group. You can also choose whether you want the rule to reopen cases or open new ones when the time window elapses.

## Add email notifications

You can configure email notifications that occur when users are assigned to cases.
For Kibana on Elastic Cloud:
1. Add the email domains to the [notifications domain allowlist](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts).
   You do not need to take any more steps to configure an email connector or update Kibana user settings, since the preconfigured Elastic-Cloud-SMTP connector is used by default.

For self-managed Kibana:
1. Create a preconfigured email connector.
   <note>
   At this time, email notifications support only preconfigured connectors, which are defined in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. For examples, refer to [Email connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors#preconfigured-email-configuration) and [Configure email accounts for well-known services](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type#configuring-email).
   </note>
2. Set the `notifications.connectors.default.email` Kibana setting in kibana.yml to the name of your email connector.
   ```js
   notifications.connectors.default.email: ‘mail-dev’

   xpack.actions.preconfigured:
     mail-dev:
       name: preconfigured-email-notification-maildev
       actionTypeId: .email
       config:
         service: other
         from: from address
         host: host name
         port: port number
         secure: true/false
         hasAuth: true/false
   ```
3. If you want the email notifications to contain links back to the case, you must configure the [server.publicBaseUrl](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) setting.

When you subsequently add assignees to cases, they receive an email.

## Add visualizations

You can also optionally add visualizations. For example, you can portray event and alert data through charts and graphs.
![Adding a visualization as a comment within a case](https://www.elastic.co/docs/explore-analyze/images/kibana-cases-visualization.png)

To add a visualization to a comment within your case:
1. Click the **Visualization** button. The **Add visualization** dialog appears.
2. Select an existing visualization from your Visualize Library or create a new visualization.
   <important>
   Set an absolute time range for your visualization. This ensures your visualization doesn’t change over time after you save it to your case and provides important context for viewers.
   </important>
3. After you’ve finished creating your visualization, click **Save and return** to go back to your case.
4. Click **Preview** to see how the visualization will appear in the case comment.
5. Click **Add Comment** to add the visualization to your case.

Alternatively, while viewing a [dashboard](https://www.elastic.co/docs/explore-analyze/dashboards) you can open a panel’s menu then click **More > Add to existing case** or **More > Add to new case**.
After a visualization has been added to a case, you can modify or interact with it by clicking the **Open Visualization** option in the case’s comment menu.

## Manage cases

In **Management > Stack Management > Cases**, you can search cases and filter them by attributes such as assignees, categories, severity, status, and tags. You can also select multiple cases and use bulk actions to delete cases or change their attributes.
<applies-to>Elastic Stack: Generally available since 9.3</applies-to> To find cases that were created during a specific time range, use the date time picker above the Cases table. The default time selection is the last 30 days. Clicking **Show all cases** displays every Stack Management case in your space. The action also adjusts the starting time range to the date of when the first case was created.
To view a case, click on its name. You can then:
- Add and edit the case's description, comments, assignees, tags, status, severity, and category.
  <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Copy and paste images into case comments using `Ctrl/Cmd` + `C` and `Ctrl/Cmd` + `V` shortcuts. Pasted images are preformatted in Markdown.
- Add a connector (if you did not select one while creating the case).
- Send updates to external systems (if external connections are configured).
- Refresh the case to retrieve the latest updates.


## Add context and supporting materials

Provide additional context and resources by adding the following to the case:
- [Alerts](#add-case-alerts)
- [Files](#add-case-files)
- [Observables](#add-case-observables)

<tip applies-to="Elastic Stack: Generally available since 9.3">
  From the **Attachments** tab, you can search for specific observable values, alert IDs, and file names.
</tip>


### Add alerts

Escalate alerts and track them in a single place by attaching them to cases. To examine the alerts, click the **Alerts** tab in the case. In the table, alerts are organized from oldest to newest. To view alert details, click the **View details** button.
You can find the **Alerts** tab in the following places:
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to>: Go to the case's details page.

<important>
  Each case can have a maximum of 1,000 alerts.
</important>

<note>
  Refer to [View and manage alerts in Elastic Observability > Add alerts to cases](/docs/solutions/observability/incident-management/view-alerts#observability-view-alerts-add-alerts-to-cases) to learn how to add alerts to cases.
</note>


### Add files

After you create a case, you can upload and manage files on the **Files** tab. To find the tab:
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available since 9.0</applies-to>: Go to the case's details page.

To download or delete the file or copy the file hash to your clipboard, open the action menu `boxes_horizontal`. The available hash functions are MD5, SHA-1, and SHA-256.
When you upload a file, a comment is added to the case activity log. To view an image, click its name in the activity or file list.
<important>
  When you export cases as [saved objects](https://www.elastic.co/docs/explore-analyze/find-and-organize/saved-objects), the attached case files are not exported.
</important>

<note>
  Uploaded files are also accessible from the **Files** management page, which you can find using the navigation menu or entering `Files` into the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
</note>


### Add observables

An observable is a piece of information about an investigation, for example, a suspicious URL or a file hash. Use observables to identify correlated events and better understand the severity and scope of a case.
View and manage observables from the **Observables** tab. You can find the tab in the following places:
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available since 9.0</applies-to>: Go to the case's details page.

<important>
  Each case can have a maximum of 50 observables.
</important>

To create an observable:
1. Click **Add observable** from the **Observables** tab.
2. Provide the necessary details:
   - **Type**: Select a type for the observable. You can choose a preset type or a [custom one](/docs/solutions/security/investigate/configure-case-settings#cases-observable-types).
- **Value**: Enter a value for the observable. The value must align with the type you select.
- **Description** (Optional): Provide additional information about the observable.
3. Click **Add observable**.

After adding an observable to a case, you can remove or edit it by using the **Actions** menu (**…**).
<tip>
  Go to the **Similar cases** tab to access other cases with the same observables.
</tip>


## Search cases

The **Cases** page has a search bar for quickly finding cases and case data. You can search for case titles, descriptions, and IDs using keywords and text. Note the following rules for search:
- **Keywords**: Searches for keywords (like case and alert IDs) must be exact.
- **Text**: Text searches (such as case titles and descriptions) are case-insensitive.
- **Syntax**: No special syntax is required when entering your search criteria.

<applies-to>Elastic Stack: Generally available since 9.3</applies-to> You can also search for alert and event IDs, observable values, case comments, and custom fields (text type only). For example, you can search for a specific IP address that's been specified as an observable, a colleague's comment, or the ID of an alert that's attached to the case.